/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.netcracker.profiler.io.ResettableBufferedOutputStream;
import com.netcracker.profiler.servlet.HttpServletResponseOutputWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public class GzipHttpServletResponse
extends HttpServletResponseOutputWrapper {
    private static final Pattern NO_TRANSFORM = Pattern.compile("((.*)[\\s,])?no-transform([\\s,](.*))?", 2);
    private final int threshold;
    private final Set<String> mimetypes;
    private long contentLength;
    private String vary;
    private boolean noGzip;
    private boolean closing;
    private GzipThresholdOutputStream output;

    public GzipHttpServletResponse(HttpServletResponse wrapped, int threshold, Set<String> mimetypes) {
        super(wrapped);
        this.threshold = threshold;
        this.mimetypes = mimetypes;
    }

    public void setContentLength(int contentLength) {
        this.setContentLengthLong(contentLength);
    }

    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        if (name != null) {
            if ("vary".equalsIgnoreCase(name)) {
                this.vary = value;
            } else if ("content-range".equalsIgnoreCase(name)) {
                this.noGzip = value != null;
            } else if ("cache-control".equalsIgnoreCase(name)) {
                this.noGzip = value != null && NO_TRANSFORM.matcher(value).matches();
            }
        }
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (name != null && value != null) {
            if ("vary".equalsIgnoreCase(name)) {
                this.vary = (this.vary != null ? this.vary + "," : "") + value;
            } else if ("content-range".equalsIgnoreCase(name)) {
                this.noGzip = true;
            } else if ("cache-control".equalsIgnoreCase(name)) {
                this.noGzip = this.noGzip || NO_TRANSFORM.matcher(value).matches();
            }
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.isCommitted()) {
            super.flushBuffer();
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (!this.isCommitted()) {
            this.contentLength = 0L;
            this.vary = null;
            this.noGzip = false;
            if (this.output != null) {
                this.output.reset();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        super.close();
        this.closing = false;
    }

    @Override
    protected OutputStream createOutputStream() {
        this.output = new GzipThresholdOutputStream(this.threshold);
        return this.output;
    }

    private class GzipThresholdOutputStream
    extends ResettableBufferedOutputStream {
        private GzipThresholdOutputStream(int threshold) {
            super(threshold);
        }

        @Override
        public OutputStream createOutputStream(boolean doGzip) throws IOException {
            String contentType;
            HttpServletResponse originalResponse = (HttpServletResponse)GzipHttpServletResponse.this.getResponse();
            if (doGzip && !GzipHttpServletResponse.this.noGzip && (GzipHttpServletResponse.this.closing || !GzipHttpServletResponse.this.isCommitted()) && (contentType = GzipHttpServletResponse.this.getContentType()) != null && GzipHttpServletResponse.this.mimetypes.contains(contentType.split(";", 2)[0])) {
                GzipHttpServletResponse.this.addHeader("Content-Encoding", "gzip");
                GzipHttpServletResponse.this.setHeader("Vary", (GzipHttpServletResponse.this.vary != null && !"*".equals(GzipHttpServletResponse.this.vary) ? GzipHttpServletResponse.this.vary + "," : "") + "Accept-Encoding");
                return new GZIPOutputStream((OutputStream)originalResponse.getOutputStream());
            }
            if (!doGzip) {
                GzipHttpServletResponse.this.setContentLength(this.getWrittenBytes());
            }
            if (GzipHttpServletResponse.this.contentLength > 0L) {
                originalResponse.setHeader("Content-Length", String.valueOf(GzipHttpServletResponse.this.contentLength));
            }
            return originalResponse.getOutputStream();
        }
    }
}

