/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.netcracker.profiler.io.exceptions.ErrorCollector;
import com.netcracker.profiler.io.exceptions.ErrorSupervisor;
import com.netcracker.profiler.output.layout.Layout;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class HttpServletBase<Mediator, Context>
extends HttpServlet {
    protected long parseLong(HttpServletRequest request, String paramName, long defaultValue) throws IllegalArgumentException {
        String s = request.getParameter(paramName);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ErrorSupervisor supervisor = this.createSupervisor();
        ErrorSupervisor.push((ErrorSupervisor)supervisor);
        Context context = this.createContext();
        try {
            Layout layout = this.identifyLayout(context, req, resp);
            Mediator mediator = this.getMediator(context, req, resp, layout);
            Runnable action = this.identifyAction(context, req, resp, mediator);
            action.run();
        }
        finally {
            ErrorSupervisor.pop();
        }
    }

    protected ErrorSupervisor createSupervisor() {
        return new ErrorCollector();
    }

    protected Context createContext() {
        return null;
    }

    protected abstract Layout identifyLayout(Context var1, HttpServletRequest var2, HttpServletResponse var3);

    protected abstract Mediator getMediator(Context var1, HttpServletRequest var2, HttpServletResponse var3, Layout var4);

    protected abstract Runnable identifyAction(Context var1, HttpServletRequest var2, HttpServletResponse var3, Mediator var4);
}

