/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.netcracker.profiler.io.DefaultServletOutputStream;
import com.netcracker.profiler.io.ResettableBuffer;
import com.netcracker.profiler.io.ResettableBufferedOutputStream;
import com.netcracker.profiler.io.ResettableBufferedWriter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class HttpServletResponseOutputWrapper
extends HttpServletResponseWrapper {
    private static final String ERROR_GETOUTPUT_ALREADY_CALLED = "getOutputStream() has already been called on this response.";
    private static final String ERROR_GETWRITER_ALREADY_CALLED = "getWriter() has already been called on this response.";
    private ServletOutputStream output;
    private PrintWriter writer;
    private ResettableBuffer buffer;
    private boolean passThrough;

    protected HttpServletResponseOutputWrapper(HttpServletResponse wrappedResponse) {
        super(wrappedResponse);
    }

    protected abstract OutputStream createOutputStream();

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.passThrough) {
            return super.getOutputStream();
        }
        if (this.writer != null) {
            throw new IllegalStateException(ERROR_GETWRITER_ALREADY_CALLED);
        }
        if (this.output == null) {
            this.buffer = new ResettableBufferedOutputStream(this.createOutputStream(), this.getBufferSize());
            this.output = new DefaultServletOutputStream((OutputStream)((Object)this.buffer));
        }
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.passThrough) {
            return super.getWriter();
        }
        if (this.output != null) {
            throw new IllegalStateException(ERROR_GETOUTPUT_ALREADY_CALLED);
        }
        if (this.writer == null) {
            this.buffer = new ResettableBufferedWriter(new OutputStreamWriter(this.createOutputStream(), this.getCharacterEncoding()), this.getBufferSize(), this.getCharacterEncoding());
            this.writer = new PrintWriter((Writer)((Object)this.buffer));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.passThrough) {
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.output != null) {
            this.output.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.output != null) {
            this.output.close();
        }
    }

    public void reset() {
        super.reset();
        if (this.buffer != null) {
            this.buffer.reset();
        }
    }

    public boolean isCommitted() {
        return super.isCommitted() || this.buffer != null && !this.buffer.isResettable();
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }
}

