/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.catalog.model.dto.chain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Schema(description = "Response object containing information about the difference between two chains/snapshots")
public class EntityDifferenceResponse {

    @Schema(description = "Original chain lite object")
    private ChainLiteDTO leftEntity;
    @Schema(description = "Modified chain lite object")
    private ChainLiteDTO rightEntity;
    @Schema(description = "List containing information about the difference between chains elements")
    private List<ChainElementDifferenceDTO> elementsDifferences;
}
