/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.expressions;

import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.expression.parser.ParseException;
import java.io.Reader;
import java.io.StringReader;
import org.qubership.integration.platform.engine.mapper.atlasmap.expressions.CustomExpressionParser;

public interface CustomExpression
extends Expression {
    public static Expression parse(String expessionText, FunctionResolver functionResolver) throws ExpressionException {
        Object result;
        if (functionResolver == null) {
            functionResolver = (name, args) -> {
                throw new ParseException("Function not found: " + name);
            };
        }
        if ((result = CACHE.get((Object)expessionText)) instanceof ExpressionException) {
            throw (ExpressionException)result;
        }
        if (result instanceof Expression) {
            return (Expression)result;
        }
        String actual = expessionText;
        try {
            CustomExpressionParser parser = new CustomExpressionParser((Reader)new StringReader(actual));
            parser.functionResolver = functionResolver;
            Expression e = parser.parse();
            CACHE.put((Object)expessionText, (Object)e);
            return e;
        }
        catch (Throwable e) {
            ExpressionException fe = new ExpressionException(actual, e);
            CACHE.put((Object)expessionText, (Object)fe);
            throw fe;
        }
    }
}

