/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.qubership.integration.platform.engine.forms.FormData;
import org.qubership.integration.platform.engine.forms.FormEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class FormDataConverter
implements TypeConverter {
    private static final TypeReference<List<FormEntry>> formEntryListTypeReference = new TypeReference<List<FormEntry>>(){};
    private final ObjectMapper objectMapper;

    @Autowired
    public FormDataConverter(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean allowNull() {
        return false;
    }

    public <T> T convertTo(Class<T> type, Object value) throws TypeConversionException {
        try {
            List entries = (List)this.objectMapper.readValue(value.toString(), formEntryListTypeReference);
            return (T)FormData.builder().entries(entries).build();
        }
        catch (JsonProcessingException exception) {
            throw new TypeConversionException(value, type, (Throwable)exception);
        }
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        return this.convertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return this.convertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return this.convertTo(type, value);
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (TypeConversionException ignored) {
            return null;
        }
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (TypeConversionException ignored) {
            return null;
        }
    }
}

