/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.engine.model.logging.LogPayload;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.debugger.logging.ChainLogger;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsService;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpTriggerFinishProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(HttpTriggerFinishProcessor.class);
    private final CamelDebuggerPropertiesService propertiesService;
    private final PayloadExtractor payloadExtractor;
    private final ChainLogger chainLogger;
    private final MetricsService metricsService;

    @Autowired
    public HttpTriggerFinishProcessor(CamelDebuggerPropertiesService propertiesService, PayloadExtractor payloadExtractor, ChainLogger chainLogger, MetricsService metricsService) {
        this.propertiesService = propertiesService;
        this.payloadExtractor = payloadExtractor;
        this.chainLogger = chainLogger;
        this.metricsService = metricsService;
    }

    public void process(Exchange exchange) throws Exception {
        Boolean sessionFailed = (Boolean)exchange.getProperty("internalProperty_httpThreadFailed", (Object)false, Boolean.class);
        Exception exception = sessionFailed != false ? (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class) : null;
        CamelDebuggerProperties dbgProperties = this.getCamelDebuggerProperties(exchange);
        this.logHttpTriggerRequestFinished(exchange, dbgProperties, exception);
        this.logMetrics(exchange, dbgProperties, exception);
    }

    private void logMetrics(Exchange exchange, CamelDebuggerProperties dbgProperties, Exception exception) {
        try {
            int responseCode = PayloadExtractor.getServletResponseCode(exchange, exception);
            this.metricsService.processHttpResponseCode(dbgProperties, String.valueOf(responseCode));
            this.metricsService.processHttpTriggerPayloadSize(exchange, dbgProperties);
        }
        catch (Exception e) {
            log.warn("Failed to create metrics data", (Throwable)e);
        }
    }

    private void logHttpTriggerRequestFinished(Exchange exchange, CamelDebuggerProperties dbgProperties, Exception exception) {
        DeploymentRuntimeProperties runtimeProperties = dbgProperties.getRuntimeProperties(exchange);
        if (!runtimeProperties.getLogLoggingLevel().isInfoLevel() && exception == null) {
            return;
        }
        String started = (String)exchange.getProperty("internalProperty_startTime", String.class);
        String finished = LocalDateTime.now().toString();
        long duration = Duration.between(LocalDateTime.parse(started), LocalDateTime.parse(finished)).toMillis();
        List messageHistory = exchange.getAllProperties().getOrDefault("CamelMessageHistory", Collections.emptyList());
        String nodeId = messageHistory.stream().map(MessageHistory::getNode).filter(node -> "ref:httpTriggerProcessor".equals(node.getLabel())).findFirst().map(NamedNode::getId).orElse(null);
        String bodyForLogging = "<body not logged>";
        String headersForLogging = this.payloadExtractor.extractHeadersForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled()).toString();
        String exchangePropertiesForLogging = this.payloadExtractor.extractExchangePropertiesForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled()).toString();
        if (runtimeProperties.isLogPayloadEnabled()) {
            bodyForLogging = this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled());
        }
        if (runtimeProperties.getLogPayload() != null && !runtimeProperties.getLogPayload().isEmpty()) {
            Set<LogPayload> logPayloadSettings = runtimeProperties.getLogPayload();
            headersForLogging = logPayloadSettings.contains((Object)LogPayload.HEADERS) ? headersForLogging : "<headers not logged>";
            exchangePropertiesForLogging = logPayloadSettings.contains((Object)LogPayload.PROPERTIES) ? exchangePropertiesForLogging : "<properties not logged>";
            bodyForLogging = logPayloadSettings.contains((Object)LogPayload.BODY) ? this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()) : "<body not logged>";
        }
        this.chainLogger.logHTTPExchangeFinished(exchange, dbgProperties, bodyForLogging, headersForLogging, exchangePropertiesForLogging, nodeId, duration, exception);
    }

    private CamelDebuggerProperties getCamelDebuggerProperties(Exchange exchange) {
        CamelDebugger camelDebugger = (CamelDebugger)exchange.getContext().getDebugger();
        return this.propertiesService.getProperties(exchange, camelDebugger.getDeploymentId());
    }
}

