/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.camel.quartz;

import java.util.Map;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.component.quartz.springboot.QuartzComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.qubership.integration.platform.engine.service.QuartzSchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, QuartzComponentConfiguration.class})
public class CamelQuartzComponentCustomConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CamelQuartzComponentCustomConfiguration.class);
    public static final String THREAD_POOL_COUNT_PROP = "org.quartz.threadPool.threadCount";
    private final QuartzSchedulerService quartzSchedulerService;
    @Value(value="${qip.camel.component.quartz.thread-pool-count}")
    private String threadPoolCount;

    @Autowired
    public CamelQuartzComponentCustomConfiguration(QuartzSchedulerService quartzSchedulerService) {
        this.quartzSchedulerService = quartzSchedulerService;
    }

    @Bean
    public ComponentCustomizer quartzComponentCustomizer() {
        return ComponentCustomizer.builder(QuartzComponent.class).build(component -> {
            component.setSchedulerFactory(this.quartzSchedulerService.getFactory());
            component.setScheduler(this.quartzSchedulerService.getFactory().getScheduler());
            component.setPrefixInstanceName(false);
            component.setEnableJmx(false);
            component.setProperties(Map.of(THREAD_POOL_COUNT_PROP, this.threadPoolCount));
            log.debug("Configure quartz component via component customizer: {}", component);
        });
    }
}

