/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.opensearch;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.qubership.integration.platform.engine.opensearch.DefaultOpenSearchClientSupplier;
import org.qubership.integration.platform.engine.opensearch.OpenSearchClientSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class OpenSearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OpenSearchConfiguration.class);
    public static final String OPENSEARCH_CLIENT_SUPPLIER_BEAN_NAME = "openSearchClientSupplier";
    public static final String OPENSEARCH_ENTITY_NAME_NORMALIZER_BEAN_NAME = "openSearchEntityNameNormalizer";
    public static final long TEMPLATE_VERSION = 4L;
    @Value(value="${qip.opensearch.client.host:opensearch}")
    private String host;
    @Value(value="${qip.opensearch.client.port:9200}")
    private Integer port;
    @Value(value="${qip.opensearch.client.protocol:http}")
    private String protocol;
    @Value(value="${qip.opensearch.client.user-name:}")
    private String username;
    @Value(value="${qip.opensearch.client.password:}")
    private String password;
    @Value(value="${qip.opensearch.client.prefix:}")
    private String prefix;

    @Bean
    @ConditionalOnMissingBean(value={OpenSearchClientSupplier.class})
    public OpenSearchClientSupplier openSearchClientSupplier() {
        return new DefaultOpenSearchClientSupplier(this.createOpenSearchClient(), this.prefix);
    }

    private OpenSearchClient createOpenSearchClient() {
        AuthScope authScope = new AuthScope(null, null, -1, null, null);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password.toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{new HttpHost(this.protocol, this.host, this.port.intValue())}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider));
        return new OpenSearchClient((OpenSearchTransport)builder.build());
    }
}

