/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.errorhandling.KubeApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeOperator {
    private static final Logger log = LoggerFactory.getLogger(KubeOperator.class);
    private static final String DEFAULT_ERR_MESSAGE = "Invalid k8s cluster parameters or API error. ";
    private final CoreV1Api coreApi = new CoreV1Api();
    private final AppsV1Api appsApi;
    private final String namespace;
    private final Boolean devmode;

    public KubeOperator() {
        this.appsApi = new AppsV1Api();
        this.namespace = null;
        this.devmode = null;
    }

    public KubeOperator(ApiClient client, String namespace, Boolean devmode) {
        this.coreApi.setApiClient(client);
        this.appsApi = new AppsV1Api();
        this.appsApi.setApiClient(client);
        this.namespace = namespace;
        this.devmode = devmode;
    }

    public Map<String, Map<String, String>> getAllSecretsWithLabel(Pair<String, String> label) {
        HashMap<String, Map<String, String>> secrets = new HashMap<String, Map<String, String>>();
        try {
            V1SecretList secretList = this.coreApi.listNamespacedSecret(this.namespace, null, null, null, null, (String)label.getKey() + "=" + (String)label.getValue(), null, null, null, null, null, null);
            List secretListItems = secretList.getItems();
            for (V1Secret secret : secretListItems) {
                V1ObjectMeta metadata = secret.getMetadata();
                if (metadata == null) continue;
                ConcurrentHashMap dataMap = new ConcurrentHashMap();
                if (secret.getData() != null) {
                    secret.getData().forEach((k, v) -> dataMap.put(k, new String((byte[])v)));
                }
                secrets.put(metadata.getName(), dataMap);
            }
        }
        catch (ApiException e) {
            if (e.getCode() != 404) {
                if (!this.isDevmode().booleanValue()) {
                    log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
                }
                throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            if (!this.isDevmode().booleanValue()) {
                log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            }
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
        return secrets;
    }

    public Boolean isDevmode() {
        return this.devmode;
    }
}

