/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.model.ElementIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentifierUtils {
    private static final Logger log = LoggerFactory.getLogger(IdentifierUtils.class);
    private static final String COLON = ":";
    private static final String SESSION_WRAPPER_ELEMENT_ID = "SESSION_WRAPPER";
    private static final String SESSION_WRAPPER_CATCH_ID = "SESSION_WRAPPER_CATCH";
    private static final String SESSION_CATCH_LOG_ID = "SESSION_WRAPPER_CATCH_LOGGER";
    private static final Pattern valid_uuid = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
    private static final int MIN_ELEMENT_IDENTIFIER_PARTS = 3;
    private static final int MAX_ELEMENT_IDENTIFIERS_PARTS = 4;
    private static final int MIN_ROUTE_IDENTIFIER_PARTS = 2;
    private static final int MAX_ROUTE_IDENTIFIER_PARTS = 3;
    private static final Pattern REQUEST_ATTEMPT_ID_PATTERN = Pattern.compile("Request attempt--([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    private IdentifierUtils() {
    }

    public static Pair<String, String> parseChainIdentifier(Exchange exchange) {
        String[] identifierParts;
        String routeId = exchange.getFromRouteId();
        if (routeId != null && (identifierParts = routeId.split(COLON, 3)).length >= 2) {
            return ImmutablePair.of((Object)identifierParts[0], (Object)identifierParts[1]);
        }
        throw new IllegalArgumentException("Invalid session start route identifier: " + routeId);
    }

    public static String extractIdFromIdentifier(String nodeId) {
        boolean isServiceElement = IdentifierUtils.isServiceElement(nodeId);
        if (isServiceElement) {
            return null;
        }
        ElementIdentifier spreadIdentifier = IdentifierUtils.spreadIdentifier(nodeId);
        return spreadIdentifier.getElementId();
    }

    public static ElementIdentifier spreadIdentifier(NamedNode node) {
        String nodeId = node.getId();
        return IdentifierUtils.spreadIdentifier(nodeId);
    }

    public static ElementIdentifier spreadIdentifier(String nodeId) {
        String[] identifiers;
        if (nodeId != null && (identifiers = nodeId.split(COLON, 4)).length >= 3) {
            Object identifier = ((ElementIdentifier.ElementIdentifierBuilder)((ElementIdentifier.ElementIdentifierBuilder)((ElementIdentifier.ElementIdentifierBuilder)ElementIdentifier.builder().elementId(identifiers[0])).camelElementName(identifiers[1])).elementName(identifiers[2])).build();
            if (identifiers.length == 4) {
                ((ElementIdentifier)identifier).setExternalElementId(identifiers[3]);
            }
            return identifier;
        }
        throw new IllegalArgumentException("Invalid id format of element: " + nodeId);
    }

    public static boolean isServiceElement(NamedNode node) {
        return IdentifierUtils.isServiceElement(node.getId());
    }

    public static boolean isServiceElement(String nodeId) {
        return SESSION_WRAPPER_ELEMENT_ID.equals(nodeId) || SESSION_WRAPPER_CATCH_ID.equals(nodeId) || SESSION_CATCH_LOG_ID.equals(nodeId);
    }

    public static boolean isSessionWrapper(NamedNode node) {
        String nodeId = node.getId();
        if (nodeId != null) {
            String[] identifierParts = nodeId.split(COLON);
            return SESSION_WRAPPER_ELEMENT_ID.equals(identifierParts[0]);
        }
        return false;
    }

    public static boolean isSessionWrapperCatch(NamedNode node) {
        return SESSION_WRAPPER_CATCH_ID.equals(node.getId());
    }

    public static boolean isSessionWrapperCatchLog(NamedNode node) {
        return SESSION_CATCH_LOG_ID.equals(node.getId());
    }

    public static boolean isValidUUID(String text) {
        return valid_uuid.matcher(text).matches();
    }

    public static String getServiceCallRetryIteratorPropertyName(String elementId) {
        return String.format("internalProperty_serviceCall_%s_Iterator", elementId);
    }

    public static String getServiceCallRetryPropertyName(String elementId) {
        return String.format("internalProperty_serviceCall_%s_Retry", elementId);
    }
}

