/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainEndpoint;

@Component(value="cip-chain")
public class ChainComponent
extends DefaultComponent {
    private static final ConcurrentMap<String, List<ChainConsumer>> consumers = new ConcurrentHashMap<String, List<ChainConsumer>>();
    @Metadata(label="producer", defaultValue="true")
    private boolean block = true;
    @Metadata(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @Metadata(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @Metadata(label="advanced", defaultValue="true")
    private boolean propagateProperties = true;

    public ChainConsumer getConsumer(ChainEndpoint endpoint) {
        String key = ChainComponent.getConsumerKey(endpoint.getEndpointUri());
        List consumers = (List)this.getConsumers().get(key);
        return Objects.isNull(consumers) || consumers.isEmpty() ? null : (ChainConsumer)((Object)consumers.getLast());
    }

    public void addConsumer(ChainEndpoint endpoint, ChainConsumer consumer) {
        String key = ChainComponent.getConsumerKey(endpoint.getEndpointUri());
        this.getConsumers().merge(key, Collections.singletonList(consumer), (oldValue, value) -> {
            ArrayList result = new ArrayList(oldValue);
            result.addAll(value);
            return result;
        });
    }

    public void removeConsumer(ChainEndpoint endpoint, ChainConsumer consumer) {
        String key = ChainComponent.getConsumerKey(endpoint.getEndpointUri());
        this.getConsumers().compute(key, (k, oldValue) -> {
            if (Objects.isNull(oldValue)) {
                return null;
            }
            ArrayList result = new ArrayList(oldValue);
            result.remove((Object)consumer);
            return result.isEmpty() ? null : result;
        });
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ChainEndpoint answer = new ChainEndpoint(uri, this);
        answer.setBlock(this.isBlock());
        answer.setTimeout(this.getTimeout());
        answer.setPropagateProperties(this.isPropagateProperties());
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    private ConcurrentMap<String, List<ChainConsumer>> getConsumers() {
        return consumers;
    }

    private static String getConsumerKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isPropagateProperties() {
        return this.propagateProperties;
    }

    public void setPropagateProperties(boolean propagateProperties) {
        this.propagateProperties = propagateProperties;
    }
}

