/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.graphql;

import java.util.Arrays;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.qubership.integration.platform.engine.camel.components.graphql.GraphqlCustomProducer;

@UriEndpoint(firstVersion="3.0.0", scheme="graphql-custom", title="GraphQL", syntax="graphql-custom:httpUri", category={Category.API}, producerOnly=true, lenientProperties=true)
public class GraphqlCustomEndpoint
extends GraphqlEndpoint {
    @UriParam(label="advanced", description="HTTP client configurer")
    private HttpClientConfigurer httpClientConfigurer;

    public GraphqlCustomEndpoint(String uri, Component component) {
        super(uri, component);
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public Producer createProducer() throws Exception {
        return new GraphqlCustomProducer(this);
    }

    public CloseableHttpClient getHttpclient() {
        CloseableHttpClient httpClient = this.getHttpClient();
        if (httpClient == null) {
            httpClient = this.createHttpClient();
            this.setHttpClient(httpClient);
        }
        return httpClient;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientConfigurer configurer;
        String accessToken;
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        String proxyHost = this.getProxyHost();
        if (proxyHost != null) {
            String[] parts = proxyHost.split(":");
            String hostname = parts[0];
            int port = Integer.parseInt(parts[1]);
            httpClientBuilder.setProxy(new HttpHost(hostname, port));
        }
        if ((accessToken = this.getAccessToken()) != null) {
            String authType = "Bearer";
            String jwtAuthorizationType = this.getJwtAuthorizationType();
            if (jwtAuthorizationType != null) {
                authType = jwtAuthorizationType;
            }
            httpClientBuilder.setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", (Object)(authType + " " + accessToken))));
        }
        String username = this.getUsername();
        String password = this.getPassword();
        if (username != null && password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((configurer = this.getHttpClientConfigurer()) != null) {
            configurer.configureHttpClient(httpClientBuilder);
        }
        return httpClientBuilder.build();
    }
}

