/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;

public class FormatDateTimeFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "formatDateTime";
    }

    public Expression create(List<Expression> args) throws ParseException {
        int argCount = args.size();
        if (argCount < 2 || argCount > 10) {
            String message = String.format("%s expects from 2 to 10 argument.", this.getName());
            throw new ParseException(message);
        }
        Expression formatStringExpression = args.get(0);
        Expression yearExpression = args.get(1);
        Expression monthExpression = argCount > 2 ? args.get(2) : null;
        Expression dayExpression = argCount > 3 ? args.get(3) : null;
        Expression hourExpression = argCount > 4 ? args.get(4) : null;
        Expression minuteExpression = argCount > 5 ? args.get(5) : null;
        Expression secondExpression = argCount > 6 ? args.get(6) : null;
        Expression millisecondExpression = argCount > 7 ? args.get(7) : null;
        Expression timezoneExpression = argCount > 8 ? args.get(8) : null;
        Expression localeExpression = argCount > 9 ? args.get(9) : null;
        return ctx -> {
            Optional<String> formatString = this.evaluateArgument(formatStringExpression, ctx);
            Optional<Integer> year = this.evaluateIntegerArgument(yearExpression, ctx);
            Optional<Integer> month = this.evaluateIntegerArgument(monthExpression, ctx);
            Optional<Integer> day = this.evaluateIntegerArgument(dayExpression, ctx);
            Optional<Integer> hour = this.evaluateIntegerArgument(hourExpression, ctx);
            Optional<Integer> minute = this.evaluateIntegerArgument(minuteExpression, ctx);
            Optional<Integer> second = this.evaluateIntegerArgument(secondExpression, ctx);
            Optional<Integer> millisecond = this.evaluateIntegerArgument(millisecondExpression, ctx);
            Optional<TimeZone> timezone = this.evaluateArgument(timezoneExpression, ctx).map(TimeZone::getTimeZone);
            Optional<Locale> locale = this.evaluateArgument(localeExpression, ctx).map(Locale::forLanguageTag);
            DateTimeFormatter formatter = formatString.map(s -> DateTimeFormatter.ofPattern(s, locale.orElse(Locale.getDefault()))).orElseThrow(() -> new ExpressionException("Format string not set"));
            OffsetDateTime timestamp = OffsetDateTime.of(year.orElse(0), month.orElse(1), day.orElse(1), hour.orElse(0), minute.orElse(0), second.orElse(0), millisecond.orElse(0) * 1000000, timezone.orElse(TimeZone.getDefault()).toZoneId().getRules().getOffset(Instant.now()));
            return AtlasModelFactory.wrapWithField((Object)formatter.format(timestamp));
        };
    }

    private Optional<String> evaluateArgument(Expression expression, ExpressionContext ctx) throws ExpressionException {
        return Objects.isNull(expression) ? Optional.empty() : Optional.ofNullable(expression.evaluate(ctx)).map(Field::getValue).map(Object::toString);
    }

    private Optional<Integer> evaluateIntegerArgument(Expression expression, ExpressionContext ctx) throws ExpressionException {
        return this.evaluateArgument(expression, ctx).map(Integer::valueOf);
    }
}

