/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.idempotency;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryKeyStrategy;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryKeyStrategyBuilder;

public class IdempotentRepositoryKeyStrategyBuilder {
    private List<Function<BuildContext, String>> appenders;

    public IdempotentRepositoryKeyStrategyBuilder reset() {
        this.appenders = null;
        return this;
    }

    public IdempotentRepositoryKeyStrategyBuilder append(String string) {
        this.getAppenders().add(context -> string);
        return this;
    }

    public IdempotentRepositoryKeyStrategyBuilder appendIdempotencyKey() {
        this.getAppenders().add(BuildContext::idempotencyKey);
        return this;
    }

    public IdempotentRepositoryKeyStrategy build() {
        return new IdempotentRepositoryKeyStrategyImpl(this.getAppenders());
    }

    private List<Function<BuildContext, String>> getAppenders() {
        if (Objects.isNull(this.appenders)) {
            this.appenders = new ArrayList();
        }
        return this.appenders;
    }
}

