/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.util.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class GraphQLVariablesProcessor
implements Processor {
    private final ObjectMapper objectMapper;

    @Autowired
    public GraphQLVariablesProcessor(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void process(Exchange exchange) throws Exception {
        String variablesJSON = (String)exchange.getProperty("internalProperty_graphQLVariablesJSON", String.class);
        JsonObject variables = StringUtils.isNotEmpty((CharSequence)variablesJSON) ? (JsonObject)this.objectMapper.readValue(variablesJSON, JsonObject.class) : new JsonObject();
        exchange.getMessage().setHeader("CamelGraphQLVariables", (Object)variables);
    }
}

