/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration
@EnableScheduling
@EnableRetry
@EnableAsync
@ComponentScan(value={"org.qubership.integration.platform.engine"})
public class ApplicationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationAutoConfiguration.class);
    private final ApplicationContext context;
    private final String microserviceName;
    private final String cloudServiceName;

    public ApplicationAutoConfiguration(ApplicationContext context, @Value(value="${spring.application.cloud_service_name}") String cloudServiceName, @Value(value="${spring.application.name}") String microserviceName) {
        this.context = context;
        this.microserviceName = microserviceName;
        this.cloudServiceName = cloudServiceName;
    }

    public String getDeploymentName() {
        return this.cloudServiceName;
    }

    public void closeApplicationWithError() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
        System.exit(1);
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getCloudServiceName() {
        return this.cloudServiceName;
    }
}

