/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import org.apache.camel.observation.MicrometerObservationTracer;
import org.apache.camel.observation.starter.ObservationConfigurationProperties;
import org.qubership.integration.platform.engine.service.debugger.tracing.MicrometerObservationTaggedTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableConfigurationProperties(value={ObservationConfigurationProperties.class})
public class TracingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TracingConfiguration.class);
    @Value(value="${management.tracing.enabled}")
    private boolean tracingEnabled;

    @Bean(initMethod="", destroyMethod="")
    @Scope(value="prototype")
    MicrometerObservationTracer camelObservationTracer(ObservationConfigurationProperties config, ObjectProvider<Tracer> tracer, ObjectProvider<ObservationRegistry> observationRegistry) {
        MicrometerObservationTaggedTracer micrometerObservationTracer = new MicrometerObservationTaggedTracer();
        tracer.ifAvailable(arg_0 -> ((MicrometerObservationTaggedTracer)micrometerObservationTracer).setTracer(arg_0));
        observationRegistry.ifAvailable(arg_0 -> ((MicrometerObservationTaggedTracer)micrometerObservationTracer).setObservationRegistry(arg_0));
        if (config.getExcludePatterns() != null) {
            micrometerObservationTracer.setExcludePatterns(config.getExcludePatterns());
        }
        if (config.getEncoding() != null) {
            micrometerObservationTracer.setEncoding(config.getEncoding().booleanValue());
        }
        return micrometerObservationTracer;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }
}

