/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.constants;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.component.springrabbit.SpringRabbitMQConstants;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CamelConstants {
    private static final Set<String> INTERNAL_PROPERTIES_NAMES;
    private static final Set<String> INTERNAL_HEADERS_NAMES;
    public static final String INTERNAL_PROPERTY_PREFIX = "internalProperty_";
    public static final String LOG_TYPE_KEY = "logType";
    public static final String LOG_TYPE_VALUE = "int";
    public static final String MASKING_TEMPLATE = "******";
    public static final String UUID_REGEXP_STRING = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    public static final Pattern UUID_STEP_REG_EXP_PATTERN;
    public static final String STEP_NAME_ID_PATTERN = "^[\\s\\S]{0,}--";
    public static final Pattern NAME_STEP_REG_EXP_PATTERN;
    public static final Pattern CUSTOM_STEP_ID_PATTERN;

    public static boolean isInternalProperty(String key) {
        return INTERNAL_PROPERTIES_NAMES.contains(key) || key != null && key.startsWith("internalProperty_");
    }

    public static boolean isInternalHeader(String header) {
        return INTERNAL_HEADERS_NAMES.contains(header);
    }

    private static void extractPublicStringFieldsToMap(Set<String> internalProperties, Class<?> aClass) throws IllegalAccessException {
        for (Field field : aClass.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !field.getType().getSimpleName().equals("String")) continue;
            internalProperties.add((String)field.get(aClass));
        }
    }

    private CamelConstants() {
    }

    static {
        UUID_STEP_REG_EXP_PATTERN = Pattern.compile("--[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);
        NAME_STEP_REG_EXP_PATTERN = Pattern.compile("^[\\s\\S]{0,}--", 2);
        CUSTOM_STEP_ID_PATTERN = Pattern.compile("^[\\s\\S]{0,}--[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);
        TreeSet exchangeProperties = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        TreeSet internalProperties = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        TreeSet internalHeaders = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        try {
            CamelConstants.extractPublicStringFieldsToMap(internalProperties, Properties.class);
            CamelConstants.extractPublicStringFieldsToMap(exchangeProperties, Exchange.class);
            CamelConstants.extractPublicStringFieldsToMap(exchangeProperties, SpringRabbitMQConstants.class);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize internal properties/headers map in static block", e);
        }
        internalProperties.addAll(exchangeProperties);
        internalHeaders.addAll(exchangeProperties);
        internalProperties.remove("originalSessionId");
        internalProperties.remove("parentSessionId");
        internalProperties.add("OpenTracing.activeSpan");
        INTERNAL_PROPERTIES_NAMES = Collections.unmodifiableSet(internalProperties);
        internalHeaders.addAll(Set.of("external-session-cip-id", "CamelGraphQLVariables", "scheduler", "jobDetail", "trigger", "jobInstance"));
        INTERNAL_HEADERS_NAMES = Collections.unmodifiableSet(internalHeaders);
    }
}

