/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryKeyStrategy;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryParameters;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.idempotency.IdempotencyKeyStrategyFactory;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
@ConditionalOnProperty(value={"qip.idempotency.enabled"}, havingValue="true", matchIfMissing=true)
public class IdempotentConsumerDependencyBinder
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(IdempotentConsumerDependencyBinder.class);
    private final Function<IdempotentRepositoryParameters, IdempotentRepository> idempotentRepositoryFactory;
    private final Collection<IdempotencyKeyStrategyFactory> keyStrategyFactories;

    @Autowired
    public IdempotentConsumerDependencyBinder(Function<IdempotentRepositoryParameters, IdempotentRepository> idempotentRepositoryFactory, Collection<IdempotencyKeyStrategyFactory> keyStrategyFactories) {
        this.idempotentRepositoryFactory = idempotentRepositoryFactory;
        this.keyStrategyFactories = keyStrategyFactories;
    }

    public boolean applicableTo(ElementProperties properties) {
        String elementType = (String)properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return (ChainElementType.HTTP_TRIGGER.equals((Object)chainElementType) || ChainElementType.KAFKA_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.RABBITMQ_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.ASYNCAPI_TRIGGER.equals((Object)chainElementType)) && Boolean.valueOf((String)properties.getProperties().get("idempotencyEnabled")) != false;
    }

    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        String elementId = properties.getElementId();
        IdempotentRepositoryParameters keyParameters = IdempotentRepositoryParameters.builder().ttl(Integer.valueOf((String)properties.getProperties().get("expiry")).intValue()).keyStrategy(this.getKeyStrategy(properties, deploymentInfo)).build();
        IdempotentRepository idempotentRepository = (IdempotentRepository)this.idempotentRepositoryFactory.apply(keyParameters);
        context.getRegistry().bind(elementId, (Object)idempotentRepository);
    }

    private IdempotentRepositoryKeyStrategy getKeyStrategy(ElementProperties properties, DeploymentInfo deploymentInfo) {
        Map props = properties.getProperties();
        String elementType = (String)props.get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return this.keyStrategyFactories.stream().filter(factory -> factory.getElementTypes().contains(chainElementType)).findFirst().map(factory -> factory.getStrategy(properties, deploymentInfo)).orElseThrow(() -> {
            String message = String.format("Failed to find an idempotency key strategy factory for element type: %s", elementType);
            return new RuntimeException(message);
        });
    }
}

