/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.idempotency;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryKeyStrategyBuilder;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.idempotency.IdempotencyKeyStrategyFactoryBase;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.idempotency.KafkaTriggerIdempotencyKeyStrategyFactory;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.idempotency.RabbitMQTriggerIdempotencyKeyStrategyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class AsyncApiTriggerIdempotencyKeyStrategyFactory
extends IdempotencyKeyStrategyFactoryBase {
    private final RabbitMQTriggerIdempotencyKeyStrategyFactory rabbitMQTriggerIdempotencyKeyStrategyFactory;
    private final KafkaTriggerIdempotencyKeyStrategyFactory kafkaTriggerIdempotencyKeyStrategyFactory;

    @Autowired
    public AsyncApiTriggerIdempotencyKeyStrategyFactory(RabbitMQTriggerIdempotencyKeyStrategyFactory rabbitMQTriggerIdempotencyKeyStrategyFactory, KafkaTriggerIdempotencyKeyStrategyFactory kafkaTriggerIdempotencyKeyStrategyFactory) {
        this.rabbitMQTriggerIdempotencyKeyStrategyFactory = rabbitMQTriggerIdempotencyKeyStrategyFactory;
        this.kafkaTriggerIdempotencyKeyStrategyFactory = kafkaTriggerIdempotencyKeyStrategyFactory;
    }

    public Collection<ChainElementType> getElementTypes() {
        return Set.of(ChainElementType.ASYNCAPI_TRIGGER);
    }

    protected void configureStrategy(IdempotentRepositoryKeyStrategyBuilder builder, ElementProperties properties, DeploymentInfo deploymentInfo) {
        Map props = properties.getProperties();
        String protocolType = (String)props.get("integrationOperationProtocolType");
        if ("kafka".equals(protocolType)) {
            this.kafkaTriggerIdempotencyKeyStrategyFactory.configureStrategy(builder, properties, deploymentInfo);
        } else if ("amqp".equals(protocolType)) {
            this.rabbitMQTriggerIdempotencyKeyStrategyFactory.configureStrategy(builder, properties, deploymentInfo);
        }
    }
}

