package org.qubership.integration.platform.engine.rest.v1.mapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointDTO;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-03-31T09:51:25+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.6 (Eclipse Adoptium)"
)
@Component
public class CheckpointMapperImpl implements CheckpointMapper {

    private final DatatypeFactory datatypeFactory;

    public CheckpointMapperImpl() {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch ( DatatypeConfigurationException ex ) {
            throw new RuntimeException( ex );
        }
    }

    @Override
    public CheckpointDTO asDTO(Checkpoint checkpoint) {
        if ( checkpoint == null ) {
            return null;
        }

        CheckpointDTO.CheckpointDTOBuilder checkpointDTO = CheckpointDTO.builder();

        checkpointDTO.id( checkpoint.getId() );
        checkpointDTO.checkpointElementId( checkpoint.getCheckpointElementId() );
        checkpointDTO.timestamp( xmlGregorianCalendarToString( dateToXmlGregorianCalendar( checkpoint.getTimestamp() ), null ) );

        return checkpointDTO.build();
    }

    @Override
    public List<CheckpointDTO> asDTO(List<Checkpoint> checkpoints) {
        if ( checkpoints == null ) {
            return null;
        }

        List<CheckpointDTO> list = new ArrayList<CheckpointDTO>( checkpoints.size() );
        for ( Checkpoint checkpoint : checkpoints ) {
            list.add( asDTO( checkpoint ) );
        }

        return list;
    }

    private String xmlGregorianCalendarToString( XMLGregorianCalendar xcal, String dateFormat ) {
        if ( xcal == null ) {
            return null;
        }

        if (dateFormat == null ) {
            return xcal.toString();
        }
        else {
            Date d = xcal.toGregorianCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat( dateFormat );
            return sdf.format( d );
        }
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar( Date date ) {
        if ( date == null ) {
            return null;
        }

        GregorianCalendar c = new GregorianCalendar();
        c.setTime( date );
        return datatypeFactory.newXMLGregorianCalendar( c );
    }
}
