/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors.checkpoint;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.components.context.propagation.ContextOperationsWrapper;
import org.qubership.integration.platform.engine.camel.processors.checkpoint.CheckpointException;
import org.qubership.integration.platform.engine.model.checkpoint.CheckpointPayloadOptions;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.persistence.shared.entity.Property;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.CheckpointUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ContextLoaderProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ContextLoaderProcessor.class);
    private final CheckpointSessionService checkpointSessionService;
    private final ObjectMapper checkpointMapper;
    private final Optional<ContextOperationsWrapper> contextOperations;

    @Autowired
    public ContextLoaderProcessor(CheckpointSessionService checkpointSessionService, @Qualifier(value="checkpointMapper") ObjectMapper checkpointMapper, Optional<ContextOperationsWrapper> contextOperations) {
        this.checkpointSessionService = checkpointSessionService;
        this.checkpointMapper = checkpointMapper;
        this.contextOperations = contextOperations;
    }

    public void process(Exchange exchange) throws CheckpointException {
        try {
            Checkpoint checkpoint;
            CheckpointUtils.CheckpointInfo checkpointInfo = CheckpointUtils.extractTriggeredCheckpointInfo((Exchange)exchange);
            Checkpoint checkpoint2 = checkpoint = checkpointInfo != null ? this.checkpointSessionService.findCheckpoint(checkpointInfo.sessionId(), checkpointInfo.chainId(), checkpointInfo.checkpointElementId()) : null;
            if (checkpoint == null) {
                log.error("Can't find checkpoint with session id: {}, checkpoint id: {}", (Object)checkpointInfo.sessionId(), (Object)checkpointInfo.checkpointElementId());
                throw new EntityNotFoundException("Can't find checkpoint with session id: " + checkpointInfo.sessionId() + ", checkpoint id: " + checkpointInfo.checkpointElementId());
            }
            CheckpointPayloadOptions replaceOptions = this.parseReplaceOptions(exchange);
            this.restorePayloadFromCheckpoint(exchange, checkpoint);
            this.updatePayloadFromRequest(exchange, replaceOptions);
            String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
            String parentSessionId = checkpoint.getSession().getId();
            String originalSessionId = this.checkpointSessionService.findOriginalSessionInfo(parentSessionId).map(SessionInfo::getId).orElse(parentSessionId);
            CheckpointUtils.setSessionProperties((Exchange)exchange, (String)parentSessionId, (String)originalSessionId);
            this.checkpointSessionService.updateSessionParent(sessionId, parentSessionId);
        }
        catch (Exception e) {
            throw new CheckpointException("Failed to load session from checkpoint", (Throwable)e);
        }
    }

    private CheckpointPayloadOptions parseReplaceOptions(Exchange exchange) throws Exception {
        String body = MessageHelper.extractBody((Exchange)exchange);
        try {
            return StringUtils.isNotEmpty((CharSequence)body) ? (CheckpointPayloadOptions)this.checkpointMapper.readValue(body, CheckpointPayloadOptions.class) : CheckpointPayloadOptions.EMPTY;
        }
        catch (Exception e) {
            log.error("Failed to parse checkpoint options from retry request", (Throwable)e);
            throw new RuntimeException("Failed to parse checkpoint options from retry request", e);
        }
    }

    private void restorePayloadFromCheckpoint(Exchange exchange, Checkpoint checkpoint) throws IOException {
        Message message = exchange.getMessage();
        if (this.contextOperations.isPresent() && StringUtils.isNotEmpty((CharSequence)checkpoint.getContextData())) {
            Map contextData = (Map)this.checkpointMapper.readValue(checkpoint.getContextData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            ((ContextOperationsWrapper)this.contextOperations.get()).activateWithSerializableContextData(contextData);
        }
        this.deserializeProperties(checkpoint, exchange.getProperties());
        message.getHeaders().putAll((Map)this.checkpointMapper.readValue(checkpoint.getHeaders(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        message.setBody((Object)(checkpoint.getBody() == null ? null : new String(checkpoint.getBody(), StandardCharsets.UTF_8)));
    }

    private void updatePayloadFromRequest(Exchange exchange, CheckpointPayloadOptions replaceOptions) {
        exchange.getProperties().putAll(replaceOptions.getProperties());
        exchange.getMessage().getHeaders().putAll(replaceOptions.getHeaders());
        if (replaceOptions.getBody() != null) {
            exchange.getMessage().setBody((Object)replaceOptions.getBody());
        }
    }

    void deserializeProperties(Checkpoint checkpoint, Map<String, Object> result) throws IOException {
        for (Property property : checkpoint.getProperties()) {
            try {
                Class<?> clazz = Class.forName(property.getType());
                if (Serializable.class.isAssignableFrom(clazz)) {
                    result.put(property.getName(), ContextLoaderProcessor.deserializeWithMetadata((byte[])property.getValue()));
                    continue;
                }
                result.put(property.getName(), this.checkpointMapper.readValue(property.getValue(), clazz));
            }
            catch (ClassNotFoundException e) {
                try {
                    result.put(property.getName(), this.checkpointMapper.readValue(property.getValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
                }
                catch (Exception exception) {
                    result.put(property.getName(), new String(property.getValue()));
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Object deserializeWithMetadata(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return object;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

