/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors.session;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.engine.model.logging.LogPayload;
import org.qubership.integration.platform.engine.model.logging.SessionsLoggingLevel;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.qubership.integration.platform.engine.service.SdsService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.debugger.kafkareporting.SessionsKafkaReportingService;
import org.qubership.integration.platform.engine.service.debugger.logging.ChainLogger;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsService;
import org.qubership.integration.platform.engine.service.debugger.sessions.SessionsService;
import org.qubership.integration.platform.engine.service.debugger.util.DebuggerUtils;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainFinishProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ChainFinishProcessor.class);
    private final MetricsService metricsService;
    private final CamelDebuggerPropertiesService propertiesService;
    private final SessionsService sessionsService;
    private final Optional<SessionsKafkaReportingService> sessionsKafkaReportingService;
    private final Optional<SdsService> sdsService;
    private final ChainLogger chainLogger;
    private final PayloadExtractor payloadExtractor;
    private final ConcurrentHashMap<String, Long> syncDurationMap = new ConcurrentHashMap();

    @Autowired
    public ChainFinishProcessor(MetricsService metricsService, CamelDebuggerPropertiesService propertiesService, SessionsService sessionsService, Optional<SessionsKafkaReportingService> sessionsKafkaReportingService, Optional<SdsService> sdsService, ChainLogger chainLogger, PayloadExtractor payloadExtractor) {
        this.metricsService = metricsService;
        this.propertiesService = propertiesService;
        this.sessionsService = sessionsService;
        this.sessionsKafkaReportingService = sessionsKafkaReportingService;
        this.sdsService = sdsService;
        this.chainLogger = chainLogger;
        this.payloadExtractor = payloadExtractor;
    }

    public void process(Exchange exchange) throws Exception {
        AtomicInteger sessionActiveThreadCounter = (AtomicInteger)exchange.getProperty("internalProperty_sessionActiveThreadCounter", null, AtomicInteger.class);
        if (sessionActiveThreadCounter == null) {
            log.error("Property {} is null, please re-create snapshot and redeploy related chain", (Object)"internalProperty_sessionActiveThreadCounter");
        }
        long currentThreadId = Thread.currentThread().threadId();
        ExecutionStatus currentExchangeStatus = DebuggerUtils.extractExecutionStatus((Exchange)exchange);
        HashMap<Long, ExecutionStatus> threadsStatuses = (HashMap<Long, ExecutionStatus>)exchange.getProperty("internalProperty_threadSessionStatuses", Map.class);
        if (threadsStatuses == null) {
            log.warn("Can't find thread session statuses for current thread {}", (Object)currentThreadId);
            threadsStatuses = new HashMap<Long, ExecutionStatus>();
        }
        threadsStatuses.put(currentThreadId, currentExchangeStatus);
        String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
        Boolean isMainExchange = (Boolean)exchange.getProperty("internalProperty_isMainExchange", (Object)false, Boolean.class);
        if (isMainExchange.booleanValue()) {
            String started = (String)exchange.getProperty("internalProperty_startTime", String.class);
            long syncDuration = Duration.between(LocalDateTime.parse(started), LocalDateTime.now()).toMillis();
            this.syncDurationMap.merge(sessionId, syncDuration, Long::sum);
        }
        if (sessionActiveThreadCounter == null || sessionActiveThreadCounter.decrementAndGet() <= 0) {
            String sessionElementId;
            CamelDebugger camelDebugger = (CamelDebugger)exchange.getContext().getDebugger();
            CamelDebuggerProperties dbgProperties = this.propertiesService.getProperties(exchange, camelDebugger.getDeploymentId());
            ExecutionStatus executionStatus = ExecutionStatus.COMPLETED_NORMALLY;
            for (Map.Entry entry : threadsStatuses.entrySet()) {
                executionStatus = ExecutionStatus.computeHigherPriorityStatus((ExecutionStatus)((ExecutionStatus)entry.getValue()), (ExecutionStatus)executionStatus);
            }
            String started = (String)exchange.getProperty("internalProperty_startTime", String.class);
            String finished = LocalDateTime.now().toString();
            DeploymentRuntimeProperties runtimeProperties = dbgProperties.getRuntimeProperties(exchange);
            SessionsLoggingLevel sessionLevel = runtimeProperties.calculateSessionLevel(exchange);
            long duration = Duration.between(LocalDateTime.parse(started), LocalDateTime.parse(finished)).toMillis();
            if (ExecutionStatus.COMPLETED_WITH_ERRORS.equals((Object)executionStatus) && (sessionLevel == SessionsLoggingLevel.ERROR || sessionLevel == SessionsLoggingLevel.INFO) && StringUtils.isNotEmpty((CharSequence)(sessionElementId = this.sessionsService.moveFromSingleElCacheToCommonCache(sessionId)))) {
                this.sessionsService.logSessionElementAfter(exchange, (Exception)exchange.getProperty("internalProperty_lastException", Exception.class), sessionId, sessionElementId, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled());
            }
            camelDebugger.finishCheckpointSession(exchange, dbgProperties, sessionId, executionStatus, duration);
            this.sessionsService.finishSession(exchange, dbgProperties, executionStatus, finished, duration, this.syncDurationMap.getOrDefault(sessionId, 0L).longValue());
            this.syncDurationMap.remove(sessionId);
            if (runtimeProperties.getLogLoggingLevel().isInfoLevel()) {
                String bodyForLogging = "<body not logged>";
                String headersForLogging = this.payloadExtractor.extractHeadersForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled()).toString();
                String exchangePropertiesForLogging = this.payloadExtractor.extractExchangePropertiesForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled()).toString();
                if (runtimeProperties.isLogPayloadEnabled()) {
                    bodyForLogging = this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), runtimeProperties.isMaskingEnabled());
                }
                if (runtimeProperties.getLogPayload() != null && !runtimeProperties.getLogPayload().isEmpty()) {
                    Set logPayloadSettings = runtimeProperties.getLogPayload();
                    headersForLogging = logPayloadSettings.contains(LogPayload.HEADERS) ? headersForLogging : "<headers not logged>";
                    exchangePropertiesForLogging = logPayloadSettings.contains(LogPayload.PROPERTIES) ? exchangePropertiesForLogging : "<properties not logged>";
                    bodyForLogging = logPayloadSettings.contains(LogPayload.BODY) ? this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()) : "<body not logged>";
                }
                this.chainLogger.logExchangeFinished(dbgProperties, bodyForLogging, headersForLogging, exchangePropertiesForLogging, executionStatus, duration);
            }
            if (runtimeProperties.isDptEventsEnabled() && this.sessionsKafkaReportingService.isPresent()) {
                try {
                    String parentSessionId = (String)exchange.getProperty("internalProperty_parentSessionId", String.class);
                    String originalSessionId = (String)exchange.getProperty("internalProperty_originalSessionId", String.class);
                    ((SessionsKafkaReportingService)this.sessionsKafkaReportingService.get()).sendFinishedEvent(exchange, dbgProperties, sessionId, originalSessionId, parentSessionId, executionStatus);
                }
                catch (Exception e) {
                    log.error("Failed to send DPT events", (Throwable)e);
                }
            }
            if (ExecutionStatus.COMPLETED_WITH_WARNINGS.equals((Object)executionStatus) || ExecutionStatus.COMPLETED_WITH_ERRORS.equals((Object)executionStatus)) {
                try {
                    this.metricsService.processChainFailure(dbgProperties.getDeploymentInfo(), (ErrorCode)exchange.getProperty("internalProperty_laseExceptionErrorCode", (Object)ErrorCode.UNEXPECTED_BUSINESS_ERROR, ErrorCode.class));
                }
                catch (Exception e) {
                    log.warn("Failed to create chains failures metric data", (Throwable)e);
                }
            }
            try {
                this.metricsService.processSessionFinish(dbgProperties, executionStatus.toString(), duration);
            }
            catch (Exception e) {
                log.warn("Failed to create metrics data", (Throwable)e);
            }
            String sdsExecutionId = (String)exchange.getProperty("internalProperty_sdsExecutionId", String.class);
            if (sdsExecutionId != null && this.sdsService.isPresent()) {
                if (ExecutionStatus.COMPLETED_WITH_ERRORS.equals((Object)executionStatus)) {
                    ((SdsService)this.sdsService.get()).setJobInstanceFailed(sdsExecutionId, DebuggerUtils.getExceptionFromExchange((Exchange)exchange));
                } else {
                    ((SdsService)this.sdsService.get()).setJobInstanceFinished(sdsExecutionId);
                }
            }
        }
    }
}

