/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.mapper.ComplexField;

public class MergeObjectsFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "mergeObjects";
    }

    public Expression create(List<Expression> args) throws ParseException {
        return ctx -> {
            ArrayList fields = new ArrayList();
            for (Expression expression : args) {
                Field field;
                if (Objects.isNull(expression) || Objects.isNull(field = expression.evaluate(ctx))) continue;
                Field f = FieldUtils.cloneField((Field)field);
                FieldUtils.replacePathSegments((Field)f, (List)new AtlasPath(f.getPath()).getSegments(true), (List)new AtlasPath("/result").getSegments(true));
                if (f instanceof FieldGroup) {
                    FieldGroup group = (FieldGroup)f;
                    group.getField().stream().filter(ComplexField.class::isInstance).forEach(fields::add);
                    continue;
                }
                if (!(f instanceof ComplexField)) continue;
                ComplexField complexField = (ComplexField)f;
                fields.addAll(complexField.getChildFields());
            }
            ComplexField result = new ComplexField(fields);
            result.setFieldType(FieldType.COMPLEX);
            result.setCollectionType(CollectionType.NONE);
            result.setPath("/result");
            result.setName("result");
            return result;
        };
    }
}

