/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.deployment.properties;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;

public class CamelDebuggerProperties {
    private DeploymentInfo deploymentInfo;
    private AtomicReference<Map<String, DeploymentRuntimeProperties>> runtimePropertiesCacheRef;
    private Map<String, Map<String, String>> elementsProperties;
    private Set<String> maskedFields;

    public DeploymentRuntimeProperties getActualRuntimeProperties() {
        return this.getRuntimeProperties(null);
    }

    public DeploymentRuntimeProperties getRuntimeProperties(@Nullable Exchange exchange) {
        Map cacheMap;
        DeploymentRuntimeProperties exchangeRuntimeProperties;
        if (exchange != null && (exchangeRuntimeProperties = (DeploymentRuntimeProperties)exchange.getProperty("internalProperty_deploymentRuntimePropertiesMap", DeploymentRuntimeProperties.class)) != null) {
            return exchangeRuntimeProperties;
        }
        String chainId = this.deploymentInfo.getChainId();
        if (chainId != null && this.runtimePropertiesCacheRef != null && (cacheMap = (Map)this.runtimePropertiesCacheRef.get()) != null) {
            if (cacheMap.containsKey(chainId)) {
                return (DeploymentRuntimeProperties)cacheMap.get(chainId);
            }
            if (cacheMap.containsKey("default-settings")) {
                return (DeploymentRuntimeProperties)cacheMap.get("default-settings");
            }
        }
        return DeploymentRuntimeProperties.getDefaultValues();
    }

    public void setElementsProperties(List<ElementProperties> elementsProperties) {
        this.elementsProperties = elementsProperties.stream().collect(Collectors.toMap(ElementProperties::getElementId, ElementProperties::getProperties));
    }

    public Map<String, String> getElementProperty(String elementId) {
        return this.elementsProperties == null ? null : (Map)this.elementsProperties.get(elementId);
    }

    public boolean containsElementProperty(String elementId) {
        return this.elementsProperties != null && this.elementsProperties.containsKey(elementId);
    }

    public static CamelDebuggerPropertiesBuilder builder() {
        return new CamelDebuggerPropertiesBuilder();
    }

    public CamelDebuggerPropertiesBuilder toBuilder() {
        return new CamelDebuggerPropertiesBuilder().deploymentInfo(this.deploymentInfo).runtimePropertiesCacheRef(this.runtimePropertiesCacheRef).elementsProperties(this.elementsProperties).maskedFields(this.maskedFields);
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public Map<String, Map<String, String>> getElementsProperties() {
        return this.elementsProperties;
    }

    public Set<String> getMaskedFields() {
        return this.maskedFields;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public void setRuntimePropertiesCacheRef(AtomicReference<Map<String, DeploymentRuntimeProperties>> runtimePropertiesCacheRef) {
        this.runtimePropertiesCacheRef = runtimePropertiesCacheRef;
    }

    public void setMaskedFields(Set<String> maskedFields) {
        this.maskedFields = maskedFields;
    }

    public CamelDebuggerProperties(DeploymentInfo deploymentInfo, AtomicReference<Map<String, DeploymentRuntimeProperties>> runtimePropertiesCacheRef, Map<String, Map<String, String>> elementsProperties, Set<String> maskedFields) {
        this.deploymentInfo = deploymentInfo;
        this.runtimePropertiesCacheRef = runtimePropertiesCacheRef;
        this.elementsProperties = elementsProperties;
        this.maskedFields = maskedFields;
    }

    private AtomicReference<Map<String, DeploymentRuntimeProperties>> getRuntimePropertiesCacheRef() {
        return this.runtimePropertiesCacheRef;
    }
}

