/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.util.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.qubership.integration.platform.engine.service.debugger.util.json.DelegatingSerializerBase;
import org.qubership.integration.platform.engine.service.debugger.util.json.IdentitySetHelper;

class CircularReferencesFinderSerializer
extends DelegatingSerializerBase {
    private final Set<Object> scope = IdentitySetHelper.createIdentitySet();
    private final Consumer<Object> consumer;

    public CircularReferencesFinderSerializer(Consumer<Object> consumer) {
        this.consumer = consumer;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.scope.contains(value)) {
            this.consumer.accept(value);
        } else {
            this.scope.add(value);
            this.getSerializer(value).serialize(value, gen, serializers);
            this.scope.remove(value);
        }
    }
}

