/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import java.time.Duration;
import java.util.Objects;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.util.StopWatch;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumerNotAvailableException;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainBlockingProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ChainBlockingProducer.class);
    private final ChainEndpoint endpoint;

    public ChainBlockingProducer(ChainEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        this.getConsumer(exchange).getProcessor().process(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.getConsumer(exchange).getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected ChainConsumer getConsumer(Exchange exchange) throws Exception {
        ChainConsumer answer = this.endpoint.getConsumer();
        if (answer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new ChainConsumerNotAvailableException("No consumers available on endpoint: " + String.valueOf((Object)this.endpoint), exchange);
            }
            answer = this.awaitConsumer();
            if (answer == null) {
                throw new ChainConsumerNotAvailableException("No consumers available on endpoint: " + String.valueOf((Object)this.endpoint), exchange);
            }
        }
        return answer;
    }

    private ChainConsumer awaitConsumer() {
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationTimeBudget().withMaxIterations(-1).withMaxDuration(Duration.ofMillis(this.endpoint.getTimeout())).withInterval(Duration.ofMillis(500L)).build()).build();
        StopWatch watch = new StopWatch();
        ChainConsumer answer = task.run(this.endpoint::getConsumer, Objects::nonNull).orElse(null);
        LOG.debug("Waited {} for consumer to be ready", (Object)watch.taken());
        return answer;
    }
}

