/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.util.GrpcProcessorUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GrpcSenderPreProcessor
implements Processor {
    private final JsonFormat.Parser grpcParser;

    @Autowired
    public GrpcSenderPreProcessor(JsonFormat.Parser grpcParser) {
        this.grpcParser = grpcParser;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getMessage();
        String body = (String)message.getBody(String.class);
        Class<?> requestC = GrpcProcessorUtils.getRequestClass(exchange);
        Message.Builder builder = (Message.Builder)requestC.getMethod("newBuilder", new Class[0]).invoke(requestC, new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            try {
                this.grpcParser.merge(body, builder);
            }
            catch (InvalidProtocolBufferException e) {
                exchange.setRouteStop(true);
                exchange.getExchangeExtension().setInterrupted(true);
                message.setBody((Object)e.getMessage());
                message.removeHeaders("*");
                message.setHeader("CamelHttpResponseCode", (Object)400);
                return;
            }
        }
        message.setBody((Object)builder.build(), requestC);
    }
}

