/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.consul;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.consul.ConsulClient;
import org.qubership.integration.platform.engine.consul.KVNotFoundException;
import org.qubership.integration.platform.engine.events.ConsulSessionCreatedEvent;
import org.qubership.integration.platform.engine.model.consul.KeyResponse;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineInfo;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineState;
import org.qubership.integration.platform.engine.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.engine.model.kafka.systemmodel.CompiledLibraryUpdate;
import org.qubership.integration.platform.engine.service.debugger.RuntimePropertiesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class ConsulService {
    private static final Logger log = LoggerFactory.getLogger(ConsulService.class);
    private static final String SESSION_PREFIX = "qip-engine-session-";
    public static final long SESSION_RENEW_DELAY = 30000L;
    public static final String SESSION_TTL_STRING = "60s";
    private static final String WAIT_TIMEOUT_STRING = "20s";
    public static final String SESSION_BEHAVIOR = "delete";
    public static final String LOCALDEV_NODE_ID = "-" + String.valueOf(UUID.randomUUID());
    public static final String DEFAULT_CONSUL_SETTING_KEY = "default-settings";
    @Value(value="${consul.keys.prefix}")
    private String keyPrefix;
    @Value(value="${consul.keys.engine-config-root}")
    private String keyEngineConfigRoot;
    @Value(value="${consul.keys.deployments-update}")
    private String keyDeploymentsUpdate;
    @Value(value="${consul.keys.libraries-update}")
    private String keyLibrariesUpdate;
    @Value(value="${consul.keys.engines-state}")
    private String keyEnginesState;
    @Value(value="${consul.keys.runtime-configurations}")
    private String keyRuntimeConfigurations;
    @Value(value="${consul.keys.chains}")
    private String keyChains;
    @Value(value="${consul.keys.common-variables-v2}")
    private String keyCommonVariablesV2;
    @Value(value="${consul.dynamic-state-keys.enabled:false}")
    private boolean dynamicStateKeys;
    private final String keyEngineName;
    private long deploymentsStatePreviousIndex = 0L;
    private long deploymentsStateLastIndex = 0L;
    private long librariesPreviousIndex = 0L;
    private long librariesStateLastIndex = 0L;
    private long chainsRuntimePropertiesPreviousIndex = 0L;
    private long chainsRuntimePropertiesLastIndex = 0L;
    private long commonVariablesPreviousIndex = 0L;
    private long commonVariablesLastIndex = 0L;
    @Nullable
    private volatile String activeSessionId = null;
    private String previousSessionId = null;
    private final ConsulClient client;
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public ConsulService(ConsulClient client, ServerConfiguration serverConfiguration, @Qualifier(value="jsonMapper") ObjectMapper objectMapper, ApplicationEventPublisher applicationEventPublisher) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.applicationEventPublisher = applicationEventPublisher;
        EngineInfo engineInfo = serverConfiguration.getEngineInfo();
        this.keyEngineName = "/" + engineInfo.getEngineDeploymentName() + "-" + engineInfo.getDomain() + "-" + engineInfo.getHost();
    }

    public synchronized void createOrRenewSession() {
        try {
            if (this.activeSessionId == null) {
                log.debug("Create consul session");
                if (this.previousSessionId != null) {
                    this.client.deleteSession(this.previousSessionId);
                    this.previousSessionId = null;
                }
                this.activeSessionId = this.client.createSession(SESSION_PREFIX + String.valueOf(UUID.randomUUID()), SESSION_BEHAVIOR, SESSION_TTL_STRING);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ConsulSessionCreatedEvent(this));
            } else {
                log.debug("Renew consul session");
                this.client.renewSession(this.activeSessionId);
            }
        }
        catch (Exception e) {
            log.error("Failed to create/renew consul session", (Throwable)e);
            this.previousSessionId = this.activeSessionId;
            this.activeSessionId = null;
        }
    }

    public void updateEnginesState(EngineState state) {
        log.debug("Update engines state");
        String sessionId = this.activeSessionId;
        if (sessionId == null) {
            throw new RuntimeException("Active consul session is not present");
        }
        String name = this.keyEngineName + (this.dynamicStateKeys ? LOCALDEV_NODE_ID : "");
        this.client.createOrUpdateKVWithSession(this.keyPrefix + this.keyEngineConfigRoot + this.keyEnginesState + name, state, sessionId);
    }

    public Pair<Boolean, Long> waitForDeploymentsUpdate() throws KVNotFoundException {
        Pair<Long, List<KeyResponse>> pair = this.client.waitForKVChanges(this.keyPrefix + this.keyEngineConfigRoot + this.keyDeploymentsUpdate, false, this.deploymentsStateLastIndex, WAIT_TIMEOUT_STRING);
        boolean changesDetected = (Long)pair.getLeft() != this.deploymentsStateLastIndex;
        this.deploymentsStatePreviousIndex = this.deploymentsStateLastIndex;
        this.deploymentsStateLastIndex = (Long)pair.getLeft();
        return Pair.of((Object)changesDetected, (Object)this.parseDeploymentsUpdate(pair));
    }

    public void rollbackDeploymentsStateLastIndex() {
        this.deploymentsStateLastIndex = this.deploymentsStatePreviousIndex;
    }

    private Long parseDeploymentsUpdate(Pair<Long, List<KeyResponse>> pair) {
        List response = (List)pair.getRight();
        switch (response.size()) {
            case 0: {
                return 0L;
            }
            case 1: {
                String value = ((KeyResponse)response.get(0)).getDecodedValue();
                return value == null ? 0L : Long.parseLong(value);
            }
        }
        throw new RuntimeException("Failed to parse response, target key in consul has invalid format/size: " + String.valueOf(response));
    }

    public Pair<Boolean, List<CompiledLibraryUpdate>> waitForLibrariesUpdate() throws KVNotFoundException, JsonProcessingException {
        Pair<Long, List<KeyResponse>> pair = this.client.waitForKVChanges(this.keyPrefix + this.keyEngineConfigRoot + this.keyLibrariesUpdate, false, this.librariesStateLastIndex, WAIT_TIMEOUT_STRING);
        boolean changesDetected = (Long)pair.getLeft() != this.librariesStateLastIndex;
        this.librariesPreviousIndex = this.librariesStateLastIndex;
        this.librariesStateLastIndex = (Long)pair.getLeft();
        return Pair.of((Object)changesDetected, this.parseLibrariesUpdate(pair));
    }

    public void rollbackLibrariesLastIndex() {
        this.librariesStateLastIndex = this.librariesPreviousIndex;
    }

    private List<CompiledLibraryUpdate> parseLibrariesUpdate(Pair<Long, List<KeyResponse>> pair) throws JsonProcessingException {
        List response = (List)pair.getRight();
        switch (response.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                String json = ((KeyResponse)response.get(0)).getDecodedValue();
                return json == null ? Collections.emptyList() : (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<List<CompiledLibraryUpdate>>(this){});
            }
        }
        throw new RuntimeException("Failed to parse response, target key in consul has invalid format/size: " + String.valueOf(response));
    }

    public Pair<Boolean, Map<String, DeploymentRuntimeProperties>> waitForChainRuntimeConfig() throws KVNotFoundException {
        Pair<Long, List<KeyResponse>> pair = this.client.waitForKVChanges(this.keyPrefix + this.keyEngineConfigRoot + this.keyRuntimeConfigurations + this.keyChains, false, this.chainsRuntimePropertiesLastIndex, WAIT_TIMEOUT_STRING);
        boolean changesDetected = (Long)pair.getLeft() != this.chainsRuntimePropertiesLastIndex;
        this.chainsRuntimePropertiesPreviousIndex = this.chainsRuntimePropertiesLastIndex;
        this.chainsRuntimePropertiesLastIndex = (Long)pair.getLeft();
        return Pair.of((Object)changesDetected, this.parseChainsRuntimeConfig(pair));
    }

    private Map<String, DeploymentRuntimeProperties> parseChainsRuntimeConfig(Pair<Long, List<KeyResponse>> pair) throws RuntimePropertiesException {
        List response = (List)pair.getRight();
        if (response.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, DeploymentRuntimeProperties> result = new HashMap<String, DeploymentRuntimeProperties>();
        boolean exception = false;
        for (KeyResponse keyResponse : response) {
            String chainId = this.parseChainId(keyResponse);
            if (chainId == null) {
                throw new RuntimePropertiesException("Failed to parse response, invalid 'key' field: " + keyResponse.getKey());
            }
            String value = keyResponse.getDecodedValue();
            try {
                result.put(chainId, (DeploymentRuntimeProperties)this.objectMapper.readValue(value, DeploymentRuntimeProperties.class));
            }
            catch (Exception e) {
                log.warn("Failed to deserialize runtime properties update for chain: {}, error: {}", (Object)chainId, (Object)e.getMessage());
                exception = true;
            }
        }
        if (exception) {
            throw new RuntimePropertiesException("Failed to deserialize consul response for one or more chains");
        }
        return result;
    }

    public void rollbackChainsRuntimeConfigLastIndex() {
        this.chainsRuntimePropertiesLastIndex = this.chainsRuntimePropertiesPreviousIndex;
    }

    public Pair<Boolean, Map<String, String>> waitForCommonVariables() throws KVNotFoundException {
        String keyPrefix = this.keyPrefix + this.keyEngineConfigRoot + this.keyCommonVariablesV2;
        Pair<Long, List<KeyResponse>> pair = this.client.waitForKVChanges(keyPrefix, false, this.commonVariablesLastIndex, WAIT_TIMEOUT_STRING);
        boolean changesDetected = (Long)pair.getLeft() != this.commonVariablesLastIndex;
        this.commonVariablesPreviousIndex = this.commonVariablesLastIndex;
        this.commonVariablesLastIndex = (Long)pair.getLeft();
        return Pair.of((Object)changesDetected, this.parseCommonVariables(((List)pair.getRight()).stream().filter(keyResponse -> ConsulService.filterL1NonEmptyPaths(keyPrefix, keyResponse.getKey())).toList()));
    }

    public void rollbackCommonVariablesLastIndex() {
        this.commonVariablesLastIndex = this.commonVariablesPreviousIndex;
    }

    private Map<String, String> parseCommonVariables(List<KeyResponse> responses) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (KeyResponse response : responses) {
            Pair<String, String> variable = this.parseCommonVariable(response);
            if (variable != null) {
                variables.put((String)variable.getKey(), variable.getValue() != null ? (String)variable.getValue() : "");
                continue;
            }
            log.warn("Can't parse common variable from response: {}", (Object)response);
        }
        return variables;
    }

    private Pair<String, String> parseCommonVariable(KeyResponse k) {
        String[] split = k.getKey().split("/");
        return split.length > 0 ? Pair.of((Object)split[split.length - 1], (Object)k.getDecodedValue()) : null;
    }

    private String parseChainId(KeyResponse k) {
        String[] keys = k.getKey().split("/");
        int keyIndex = this.getKeyIndex(keys, this.keyRuntimeConfigurations);
        int chainIdTargetIndex = keyIndex + 2;
        boolean keyIsValid = keyIndex != -1 && keys.length > chainIdTargetIndex && StringUtils.isNotEmpty((CharSequence)keys[chainIdTargetIndex]);
        return keyIsValid ? keys[chainIdTargetIndex] : null;
    }

    private int getKeyIndex(String[] keys, String targetKey) {
        int startIndex = -1;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!("/" + key).equals(targetKey)) continue;
            startIndex = i;
            break;
        }
        return startIndex;
    }

    private static boolean filterL1NonEmptyPaths(String pathPrefix, String path) {
        String[] split = path.substring(pathPrefix.length()).split("/");
        return split.length == 1 && StringUtils.isNotEmpty((CharSequence)split[0]);
    }

    @Nullable
    public String getActiveSessionId() {
        return this.activeSessionId;
    }
}

