/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Validations;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.qubership.integration.platform.engine.mapper.atlasmap.DelegatingAtlasModule;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.mapper.ComplexField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexMappingAtlasModule
extends DelegatingAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(ComplexMappingAtlasModule.class);
    private static final String SOURCE_DOCUMENT_PROPERTY_PREFIX = "Atlas.SourceDocument.";

    public ComplexMappingAtlasModule(BaseAtlasModule atlasModule) {
        super(atlasModule);
    }

    protected abstract BaseModuleValidationService<?> getValidationService();

    protected abstract BiFunction<AtlasInternalSession, String, Document> getInspectionService();

    @Override
    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        String text;
        Object sourceDocument = session.getSourceDocument(this.getDocId());
        if (sourceDocument instanceof String && (text = (String)sourceDocument).isBlank()) {
            this.handleSourceLoadError("document is blank.");
        }
        try {
            super.processPreSourceExecution(session);
        }
        catch (Exception exception) {
            this.handleSourceLoadError(exception);
        }
        Object source = session.getSourceDocument(this.getDocId());
        if (source instanceof String) {
            String sourceText = (String)source;
            try {
                session.getSourceProperties().put(SOURCE_DOCUMENT_PROPERTY_PREFIX + this.getDocId(), this.getInspectionService().apply(session, sourceText));
            }
            catch (Exception exception) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)exception.getMessage(), (AuditStatus)AuditStatus.ERROR, null);
            }
        }
    }

    private void handleSourceLoadError(String detail) throws AtlasException {
        throw new AtlasException(this.buildSourceLoadErrorMessage(detail));
    }

    private void handleSourceLoadError(Exception cause) throws AtlasException {
        throw new AtlasException(this.buildSourceLoadErrorMessage(cause.getMessage()), (Throwable)cause);
    }

    private String buildSourceLoadErrorMessage(String detail) {
        CharSequence[] formats = this.getClass().getAnnotation(AtlasModuleDetail.class).dataFormats();
        return String.format("Failed to load source data (%s): %s", String.join((CharSequence)", ", formats), detail);
    }

    @Override
    public void processPreValidation(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            throw new AtlasValidationException("Invalid session: Session and AtlasMapping must be specified");
        }
        Validations validations = atlasSession.getValidations();
        BaseModuleValidationService<?> validationService = this.getValidationService();
        validationService.setMode(this.getMode());
        validationService.setDocId(this.getDocId());
        List currentModuleValidations = validationService.validateMapping(atlasSession.getMapping());
        if (Objects.nonNull(currentModuleValidations) && !currentModuleValidations.isEmpty()) {
            validations.getValidation().addAll(currentModuleValidations);
        }
        if (LOG.isDebugEnabled() && Objects.nonNull(currentModuleValidations)) {
            LOG.debug("Detected " + currentModuleValidations.size() + " validation notices");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreValidation completed", (Object)this.getDocId());
        }
    }

    @Override
    public Boolean isSupportedField(Field field) {
        return field instanceof ComplexField || super.isSupportedField(field) != false;
    }

    @Override
    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field field;
        Field sourceField = session.head().getSourceField();
        AtlasFieldReader reader = session.getFieldReader(this.getDocId());
        if (reader == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)sourceField, (String)String.format("Source document '%s' doesn't exist", this.getDocId()), (AuditStatus)AuditStatus.ERROR, null);
            return;
        }
        if (sourceField instanceof ComplexField) {
            ComplexField complexField = (ComplexField)sourceField;
            field = this.readComplexField(session, reader, complexField);
        } else {
            field = reader.read(session);
        }
        Field field2 = field;
        session.head().setSourceField(field2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), field2.getDocId(), field2.getPath(), field2.getFieldType(), field2.getValue()});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        AtlasPath sourcePath = new AtlasPath(sourceField.getPath());
        AtlasPath targetPath = new AtlasPath(targetField.getPath());
        boolean targetHasNotIndexedCollection = FieldUtils.hasNotIndexedCollection(targetPath);
        if (sourceField instanceof ComplexField) {
            ComplexField s = (ComplexField)sourceField;
            if (targetField instanceof ComplexField) {
                ComplexField t = (ComplexField)targetField;
                AtlasPath.SegmentContext lastSegment = targetPath.getLastSegment();
                if (!FieldUtils.hasNotIndexedCollection(sourcePath) && targetHasNotIndexedCollection && t.isEmpty()) {
                    while (FieldUtils.hasNotIndexedCollection(targetPath)) {
                        targetPath.setVacantCollectionIndex(Integer.valueOf(0));
                    }
                    FieldUtils.replacePathPrefix(t, t.getPath(), targetPath.toString());
                } else if (Objects.nonNull(lastSegment.getCollectionType()) && !CollectionType.NONE.equals((Object)lastSegment.getCollectionType()) && Objects.nonNull(lastSegment.getCollectionIndex())) {
                    targetPath.setCollectionIndex(targetPath.getSegments(true).size() - 1, null);
                    FieldUtils.replacePathPrefixIndex(t, targetPath.toString(), t.getPath());
                }
                String prefix = Optional.ofNullable(s.getPath()).map(p -> p.endsWith("/") ? p.substring(0, p.length() - 1) : p).orElse("");
                Field result = t.isEmpty() ? this.copyFieldWithPathPrefixChange(this.convertComplexFieldsToGroups(s), prefix, t.getPath()) : this.populateComplexField(session, this.convertComplexFieldsToGroups(s), this.convertComplexFieldsToGroups(t));
                session.head().setTargetField(result);
                return;
            }
        }
        if (targetPath.hasCollection() && targetHasNotIndexedCollection && !(sourceField instanceof FieldGroup)) {
            FieldGroup targetFieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
            session.head().setTargetField((Field)targetFieldGroup);
            if (targetField.getFieldType() == null && sourceField.getValue() != null) {
                targetField.setFieldType(this.getConversionService().fieldTypeFromClass(sourceField.getValue().getClass()));
            }
            Field targetSubField = this.createField();
            AtlasModelFactory.copyField((Field)targetField, (Field)targetSubField, (boolean)false);
            targetPath.setVacantCollectionIndex(Integer.valueOf(0));
            targetSubField.setPath(targetPath.toString());
            session.head().setTargetField(targetSubField);
            this.populateTargetField(session);
            targetFieldGroup.getField().add(session.head().getTargetField());
            session.head().setTargetField((Field)targetFieldGroup);
            return;
        }
        if (targetPath.hasCollection() && targetHasNotIndexedCollection && sourceField instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)sourceField;
            if (targetField instanceof ComplexField) {
                ComplexField complexField = (ComplexField)targetField;
                FieldGroup targetFieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
                targetFieldGroup.setFieldType(FieldType.COMPLEX);
                targetFieldGroup.setStatus(sourceField.getStatus());
                Field previousTargetSubField = null;
                Iterator iterator = group.getField().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        session.head().setSourceField(sourceField);
                        session.head().setTargetField((Field)targetFieldGroup);
                        return;
                    }
                    Field sourceSubField = (Field)iterator.next();
                    Field targetSubField = this.cloneField(targetField);
                    this.getCollectionHelper().copyCollectionIndexes(sourceField, sourceSubField, targetSubField, previousTargetSubField);
                    FieldUtils.replacePathPrefixIndex(targetSubField, targetField.getPath(), targetSubField.getPath());
                    previousTargetSubField = targetSubField;
                    session.head().setSourceField(sourceSubField);
                    session.head().setTargetField(targetSubField);
                    this.populateTargetField(session);
                    targetFieldGroup.getField().add(session.head().getTargetField());
                }
            }
        }
        super.populateTargetField(session);
    }

    @Override
    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        AtlasFieldWriter writer = session.getFieldWriter(this.getDocId());
        Field field = session.head().getTargetField();
        this.writeField(session, writer, field);
    }

    @Override
    public Field cloneField(Field field) throws AtlasException {
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            ComplexField complexFieldCopy = new ComplexField();
            AtlasModelFactory.copyField((Field)complexField, (Field)complexFieldCopy, (boolean)true);
            for (Field f : complexField.getChildFields()) {
                complexFieldCopy.getChildFields().add(this.cloneField(f));
            }
            return complexFieldCopy;
        }
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            FieldGroup groupCopy = AtlasModelFactory.copyFieldGroup((FieldGroup)group);
            for (Field f : group.getField()) {
                groupCopy.getField().add(this.cloneField(f));
            }
            return groupCopy;
        }
        return super.cloneField(field);
    }

    private Field readComplexField(AtlasInternalSession session, AtlasFieldReader reader, ComplexField complexField) throws AtlasException {
        Field restoredField = this.buildComplexFieldTree(session, complexField);
        if (!(restoredField instanceof FieldGroup)) {
            if (Objects.nonNull(restoredField.getIndex())) {
                restoredField.setCollectionType(CollectionType.NONE);
                restoredField.setIndex(null);
            }
            restoredField.setFieldType(FieldType.ANY);
        }
        session.head().setSourceField(restoredField);
        Field field = reader.read(session);
        return this.convertGroupsToComplexFields(field);
    }

    private Field buildComplexFieldTree(AtlasInternalSession session, Field field) {
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            return this.buildComplexFieldTreeForGroup(session, group);
        }
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            return complexField.isEmpty() ? this.buildFieldFromSourceDocument(session, complexField.getPath()).orElse((Field)complexField.asFieldGroup()) : this.buildComplexFieldTreeForGroup(session, complexField.asFieldGroup());
        }
        return field;
    }

    private Field buildComplexFieldTreeForGroup(AtlasInternalSession session, FieldGroup group) {
        FieldGroup result = new FieldGroup();
        AtlasModelFactory.copyField((Field)group, (Field)result, (boolean)true);
        result.setValue(group.getValue());
        group.getField().stream().map(field -> this.buildComplexFieldTree(session, (Field)field)).forEach(result.getField()::add);
        return result;
    }

    private void writeField(AtlasInternalSession session, AtlasFieldWriter writer, Field field) throws AtlasException {
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            for (Field f : group.getField()) {
                this.writeField(session, writer, f);
            }
        } else {
            if (Objects.nonNull(field.getValue()) && FieldStatus.NOT_FOUND.equals((Object)field.getStatus())) {
                field.setStatus(FieldStatus.SUPPORTED);
            }
            session.head().setTargetField(field);
            writer.write(session);
        }
    }

    private Field copyFieldWithPathPrefixChange(Field field, String oldPathPrefix, String newPathPrefix) {
        Field result;
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            result = new FieldGroup();
            AtlasModelFactory.copyField((Field)group, (Field)result, (boolean)true);
            group.getField().stream().map(f -> this.copyFieldWithPathPrefixChange((Field)f, oldPathPrefix, newPathPrefix)).forEach(((FieldGroup)result).getField()::add);
        } else {
            result = this.createField();
            AtlasModelFactory.copyField((Field)field, (Field)result, (boolean)true);
        }
        result.setValue(field.getValue());
        if (Objects.nonNull(result.getPath()) && (oldPathPrefix.isEmpty() || result.getPath().startsWith(oldPathPrefix))) {
            String path = newPathPrefix + result.getPath().substring(oldPathPrefix.length());
            result.setPath(path);
        }
        return result;
    }

    private Optional<Field> buildFieldFromSourceDocument(AtlasInternalSession session, String path) {
        return Optional.ofNullable(session.getSourceProperties().get(SOURCE_DOCUMENT_PROPERTY_PREFIX + this.getDocId())).map(Document.class::cast).flatMap(document -> this.findFieldsInDocument((Document)document, path).stream().findFirst());
    }

    Field populateComplexField(AtlasInternalSession session, Field sourceField, Field targetField) throws AtlasException {
        if (targetField instanceof ComplexField) {
            ComplexField complexField = (ComplexField)targetField;
            targetField = complexField.asFieldGroup();
        }
        if (sourceField instanceof FieldGroup) {
            FieldGroup sourceGroup = (FieldGroup)sourceField;
            if (targetField instanceof FieldGroup) {
                FieldGroup targetGroup = (FieldGroup)targetField;
                FieldGroup group = new FieldGroup();
                AtlasModelFactory.copyField((Field)sourceField, (Field)group, (boolean)true);
                group.setValue(sourceField.getValue());
                group.setPath(targetGroup.getPath());
                for (Field field : targetGroup.getField()) {
                    Field matchingSourceField = sourceGroup.getField().stream().filter(f -> f.getName().equals(field.getName())).findAny().orElse(field);
                    Field populatedField = this.populateComplexField(session, matchingSourceField, field);
                    group.getField().add(populatedField);
                }
                return group;
            }
        }
        session.head().setSourceField(sourceField);
        session.head().setTargetField(targetField);
        super.populateTargetField(session);
        return session.head().getTargetField();
    }

    private List<Field> findFieldsInDocument(Document document, String path) {
        FieldGroup rootField = new FieldGroup();
        rootField.setFieldType(FieldType.COMPLEX);
        rootField.getField().addAll(document.getFields().getField());
        AtlasPath atlasPath = new AtlasPath(path);
        CollectionType collectionType = atlasPath.getRootSegment().getCollectionType();
        boolean rootIsCollection = CollectionType.LIST.equals((Object)collectionType) || CollectionType.ARRAY.equals((Object)collectionType);
        List segments = atlasPath.getSegments(rootIsCollection);
        return this.findFields((Field)rootField, segments);
    }

    private List<Field> findFields(Field field, List<AtlasPath.SegmentContext> path) {
        if (Objects.isNull(field) || path.isEmpty()) {
            return Collections.singletonList(field);
        }
        if (!(field instanceof FieldGroup)) {
            return Collections.emptyList();
        }
        FieldGroup group = (FieldGroup)field;
        AtlasPath.SegmentContext segment = path.get(0);
        Optional<Field> currentFieldOptional = group.getField().stream().filter(f -> f.getName().equals(segment.getName())).findAny();
        if (currentFieldOptional.isEmpty()) {
            return Collections.emptyList();
        }
        Field currentField = currentFieldOptional.get();
        if ((Objects.isNull(segment.getCollectionType()) || segment.getCollectionType().equals((Object)CollectionType.NONE)) && (Objects.isNull(currentField.getCollectionType()) || currentField.getCollectionType().equals((Object)CollectionType.NONE))) {
            return this.findFields(currentField, path.subList(1, path.size()));
        }
        if (Objects.nonNull(currentField.getCollectionType()) && currentField.getCollectionType().equals((Object)segment.getCollectionType())) {
            if (Objects.isNull(segment.getCollectionIndex()) && Objects.isNull(currentField.getIndex())) {
                return this.findFields(currentField, path.subList(1, path.size()));
            }
            if (Objects.nonNull(segment.getCollectionIndex()) && segment.getCollectionIndex().equals(currentField.getIndex()) && currentField instanceof FieldGroup) {
                FieldGroup g = (FieldGroup)currentField;
                int index = currentField.getIndex();
                return index >= 0 && index < g.getField().size() ? this.findFields((Field)g.getField().get(index), path.subList(1, path.size())) : Collections.emptyList();
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private Field convertComplexFieldsToGroups(Field field) {
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            FieldGroup g = AtlasModelFactory.createFieldGroupFrom((Field)group, (boolean)true);
            group.getField().stream().map(this::convertComplexFieldsToGroups).forEachOrdered(g.getField()::add);
            g.setValue(field.getValue());
            return g;
        }
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            FieldGroup g = AtlasModelFactory.createFieldGroupFrom((Field)complexField, (boolean)true);
            g.setFieldType(FieldType.COMPLEX);
            complexField.getChildFields().stream().map(this::convertComplexFieldsToGroups).forEachOrdered(g.getField()::add);
            g.setValue(field.getValue());
            return g;
        }
        return field;
    }

    private Field convertGroupsToComplexFields(Field field) {
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            if (FieldType.COMPLEX.equals((Object)group.getFieldType()) && !FieldUtils.hasNotIndexedCollection(new AtlasPath(group.getPath()))) {
                ComplexField complexField = new ComplexField();
                AtlasModelFactory.copyField((Field)group, (Field)complexField, (boolean)true);
                group.getField().stream().map(this::convertGroupsToComplexFields).forEachOrdered(complexField.getChildFields()::add);
                complexField.setValue(group.getValue());
                return complexField;
            }
            FieldGroup g = AtlasModelFactory.createFieldGroupFrom((Field)group, (boolean)true);
            group.getField().stream().map(this::convertGroupsToComplexFields).forEachOrdered(g.getField()::add);
            g.setValue(field.getValue());
            return g;
        }
        return field;
    }
}

