/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.List;
import java.util.Objects;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;

public class GetValuesFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "getValues";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 1) {
            String message = String.format("%s function expects 1 argument.", this.getName());
            throw new ParseException(message);
        }
        Expression parentExpression = args.getFirst();
        return context -> {
            Field inputField = parentExpression.evaluate(context);
            List<Field> values = FieldUtils.getChildren(inputField);
            FieldGroup group = AtlasModelFactory.createFieldGroupFrom((Field)inputField, (boolean)true);
            int index = 0;
            for (Field field : values) {
                Field f = null;
                if (Objects.nonNull(field)) {
                    f = FieldUtils.cloneField(field);
                    FieldUtils.replacePathSegments(f, new AtlasPath(f.getPath()).getSegments(true), new AtlasPath(String.format("%s/$values<%d>", inputField.getPath(), index)).getSegments(true));
                }
                ++index;
                group.getField().add(f);
            }
            group.setFieldType(FieldType.ANY);
            group.setPath(inputField.getPath() + "/$values<>");
            group.setName("values");
            return group;
        };
    }
}

