/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonEnumField;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QipAtlasJsonFieldReader
implements AtlasFieldReader {
    private static final Logger log = LoggerFactory.getLogger(QipAtlasJsonFieldReader.class);
    private AtlasConversionService conversionService;
    private JsonNode rootNode;

    private QipAtlasJsonFieldReader() {
    }

    public QipAtlasJsonFieldReader(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Field read(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (this.rootNode == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Cannot read a field '%s' of JSON document '%s', document is null", field.getPath(), field.getDocId()), (AuditStatus)AuditStatus.ERROR, null);
            return field;
        }
        AtlasPath path = new AtlasPath(field.getPath());
        List<Field> fields = this.getJsonFieldsForPath(session, this.rootNode, field, path, 0);
        if (path.hasCollection() && !path.isIndexedCollection()) {
            FieldGroup fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
            fieldGroup.getField().addAll(fields);
            if (fields.size() == 0) {
                fieldGroup.setStatus(FieldStatus.NOT_FOUND);
            }
            session.head().setSourceField((Field)fieldGroup);
            return fieldGroup;
        }
        if (fields.size() == 1) {
            field.setValue(fields.get(0).getValue());
            return field;
        }
        if (fields.size() == 0) {
            field.setStatus(FieldStatus.NOT_FOUND);
        }
        return field;
    }

    private List<Field> getJsonFieldsForPath(AtlasInternalSession session, JsonNode node, Field field, AtlasPath path, int depth) throws AtlasException {
        AtlasPath.SegmentContext segmentContext;
        JsonNode child;
        ArrayList<Field> fields = new ArrayList<Field>();
        if (node == null) {
            return fields;
        }
        List segments = path.getSegments(true);
        if (segments.size() < depth) {
            throw new AtlasException(String.format("depth '%s' exceeds segment size '%s'", depth, segments.size()));
        }
        if (segments.size() == depth) {
            if (field.getFieldType() == FieldType.COMPLEX && !node.isValueNode()) {
                FieldGroup group = (FieldGroup)field;
                this.populateChildFields(session, node, group, path);
                fields.add((Field)group);
            } else {
                JsonField jsonField = new JsonField();
                AtlasModelFactory.copyField((Field)field, (Field)jsonField, (boolean)true);
                if (field instanceof JsonEnumField && field.getFieldType() == FieldType.COMPLEX) {
                    jsonField.setFieldType(FieldType.STRING);
                }
                Object value = this.handleValueNode(session, node, jsonField);
                jsonField.setValue(value);
                jsonField.setIndex(null);
                fields.add((Field)jsonField);
            }
            return fields;
        }
        if (depth == 0 && path.hasCollectionRoot().booleanValue()) {
            child = node;
            segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
        } else if (depth == 0 && path.getSegments(false).isEmpty()) {
            child = node;
            segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
        } else {
            if (depth == 0) {
                if (node.size() == 1 && !((AtlasPath.SegmentContext)path.getSegments(false).get(0)).getExpression().startsWith((String)this.rootNode.fieldNames().next())) {
                    node = (JsonNode)node.elements().next();
                }
                if (segments.size() > 1) {
                    depth = 1;
                }
            }
            segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
            String fieldName = segmentContext.getName();
            child = node.get(fieldName);
        }
        if (child == null) {
            return fields;
        }
        if (segmentContext.getCollectionType() == CollectionType.NONE) {
            List<Field> childFields = this.getJsonFieldsForPath(session, child, field, path, depth + 1);
            fields.addAll(childFields);
            return fields;
        }
        if (segmentContext.getCollectionIndex() != null) {
            if (child.size() <= segmentContext.getCollectionIndex()) {
                return fields;
            }
            List<Field> arrayFields = this.getJsonFieldsForPath(session, child.get(segmentContext.getCollectionIndex().intValue()), field, path, depth + 1);
            fields.addAll(arrayFields);
        } else {
            for (int i = 0; i < child.size(); ++i) {
                FieldGroup itemField;
                if (field instanceof FieldGroup) {
                    itemField = AtlasJsonModelFactory.cloneFieldGroup((FieldGroup)((FieldGroup)field));
                    AtlasPath.setCollectionIndexRecursively((FieldGroup)itemField, (int)depth, (int)i);
                } else {
                    itemField = AtlasJsonModelFactory.cloneField((JsonField)((JsonField)field), (boolean)false);
                    AtlasPath itemPath = new AtlasPath(field.getPath());
                    itemPath.setCollectionIndex(depth, Integer.valueOf(i));
                    itemField.setPath(itemPath.toString());
                }
                List<Field> arrayFields = this.getJsonFieldsForPath(session, child.get(i), (Field)itemField, new AtlasPath(itemField.getPath()), depth + 1);
                fields.addAll(arrayFields);
            }
        }
        return fields;
    }

    private void populateChildFields(AtlasInternalSession session, JsonNode node, FieldGroup fieldGroup, AtlasPath path) throws AtlasException {
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Field child : fieldGroup.getField()) {
            AtlasPath childPath = new AtlasPath(child.getPath());
            JsonNode childNode = node.get(childPath.getLastSegment().getName());
            if (childNode == null) continue;
            if (childPath.getLastSegment().getCollectionType() != CollectionType.NONE) {
                FieldGroup childGroup = this.populateCollectionItems(session, (JsonNode)((ArrayNode)childNode), child);
                newChildren.add(childGroup);
                continue;
            }
            if (child instanceof FieldGroup) {
                this.populateChildFields(session, childNode, (FieldGroup)child, childPath);
            } else {
                Object value = this.handleValueNode(session, childNode, (JsonField)child);
                child.setValue(value);
            }
            newChildren.add(child);
        }
        fieldGroup.getField().clear();
        fieldGroup.getField().addAll(newChildren);
    }

    private FieldGroup populateCollectionItems(AtlasInternalSession session, JsonNode node, Field field) throws AtlasException {
        if (!node.isArray()) {
            throw new AtlasException(String.format("Couldn't find JSON array for field %s:%s", field.getDocId(), field.getPath()));
        }
        FieldGroup group = field instanceof FieldGroup ? (FieldGroup)field : AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
        ArrayNode arrayNode = (ArrayNode)node;
        for (int i = 0; i < arrayNode.size(); ++i) {
            AtlasPath itemPath = new AtlasPath(group.getPath());
            List segments = itemPath.getSegments(true);
            itemPath.setCollectionIndex(segments.size() - 1, Integer.valueOf(i));
            if (field instanceof FieldGroup) {
                FieldGroup itemGroup = AtlasJsonModelFactory.cloneFieldGroup((FieldGroup)((FieldGroup)field));
                AtlasPath.setCollectionIndexRecursively((FieldGroup)itemGroup, (int)(segments.size() - 1), (int)i);
                this.populateChildFields(session, arrayNode.get(i), itemGroup, itemPath);
                group.getField().add(itemGroup);
                continue;
            }
            JsonField itemField = AtlasJsonModelFactory.cloneField((JsonField)((JsonField)field), (boolean)false);
            itemField.setPath(itemPath.toString());
            Object value = this.handleValueNode(session, arrayNode.get(i), itemField);
            itemField.setValue(value);
            group.getField().add(itemField);
        }
        return group;
    }

    private Object handleValueNode(AtlasInternalSession session, JsonNode valueNode, JsonField jsonField) throws AtlasException {
        if (valueNode.isNull()) {
            return null;
        }
        if (valueNode.isObject()) {
            jsonField.setFieldType(FieldType.COMPLEX);
            return null;
        }
        if (valueNode.isArray()) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)jsonField, (String)String.format("Unexpected array node is detected: '%s'", valueNode.asText()), (AuditStatus)AuditStatus.ERROR, (String)valueNode.asText());
            return null;
        }
        if (jsonField.getFieldType() != null) {
            try {
                return this.conversionService.convertType((Object)valueNode.asText(), jsonField.getFormat(), jsonField.getFieldType(), null);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (Field)jsonField, (String)String.format("Failed to convert field value '%s' into type '%s'", valueNode.asText(), jsonField.getFieldType()), (AuditStatus)AuditStatus.ERROR, (String)valueNode.asText());
                return null;
            }
        }
        if (valueNode.isTextual()) {
            return this.handleTextualNode(valueNode, jsonField);
        }
        if (valueNode.isNumber()) {
            return this.handleNumberNode(valueNode, jsonField);
        }
        if (valueNode.isBoolean()) {
            return this.handleBooleanNode(valueNode, jsonField);
        }
        if (valueNode.isContainerNode()) {
            return this.handleContainerNode(valueNode, jsonField);
        }
        if (valueNode.isNull()) {
            return null;
        }
        log.warn(String.format("Detected unsupported json type for field p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
        jsonField.setFieldType(FieldType.UNSUPPORTED);
        return valueNode.toString();
    }

    private Object handleTextualNode(JsonNode valueNode, JsonField jsonField) {
        if (jsonField.getFieldType() == null || FieldType.STRING.equals((Object)jsonField.getFieldType())) {
            jsonField.setFieldType(FieldType.STRING);
            return valueNode.textValue();
        }
        if (FieldType.CHAR.equals((Object)jsonField.getFieldType())) {
            return Character.valueOf(valueNode.textValue().charAt(0));
        }
        log.warn(String.format("Unsupported FieldType for text data t=%s p=%s docId=%s", jsonField.getFieldType().value(), jsonField.getPath(), jsonField.getDocId()));
        return valueNode.textValue();
    }

    private Object handleNumberNode(JsonNode valueNode, JsonField jsonField) {
        if (valueNode.isInt()) {
            jsonField.setFieldType(FieldType.INTEGER);
            return valueNode.intValue();
        }
        if (valueNode.isDouble()) {
            jsonField.setFieldType(FieldType.DOUBLE);
            return valueNode.doubleValue();
        }
        if (valueNode.isBigDecimal()) {
            jsonField.setFieldType(FieldType.DECIMAL);
            return valueNode.decimalValue();
        }
        if (valueNode.isFloat()) {
            jsonField.setFieldType(FieldType.DOUBLE);
            return Float.valueOf(valueNode.floatValue());
        }
        if (valueNode.isLong()) {
            jsonField.setFieldType(FieldType.LONG);
            return valueNode.longValue();
        }
        if (valueNode.isShort()) {
            jsonField.setFieldType(FieldType.SHORT);
            return valueNode.shortValue();
        }
        if (valueNode.isBigInteger()) {
            jsonField.setFieldType(FieldType.BIG_INTEGER);
            return valueNode.bigIntegerValue();
        }
        jsonField.setFieldType(FieldType.NUMBER);
        return valueNode.numberValue();
    }

    private Object handleBooleanNode(JsonNode valueNode, JsonField jsonField) {
        jsonField.setFieldType(FieldType.BOOLEAN);
        return valueNode.booleanValue();
    }

    private Object handleContainerNode(JsonNode valueNode, JsonField jsonField) throws AtlasException {
        if (valueNode.isArray()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Detected json array p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setFieldType(FieldType.COMPLEX);
            jsonField.setCollectionType(CollectionType.ARRAY);
            return valueNode.toString();
        }
        if (valueNode.isObject()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Detected json complex object p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setFieldType(FieldType.COMPLEX);
            return valueNode.toString();
        }
        throw new AtlasException("Unknown error: detected a container JSON node which is not ARRAY nor OBJECT");
    }

    public void setDocument(String document) throws AtlasException {
        if (document == null || document.isEmpty()) {
            this.rootNode = null;
            return;
        }
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES});
            JsonParser parser = factory.createParser(document);
            this.rootNode = (JsonNode)mapper.readTree(parser);
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

