/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before;

import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnBeforeDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"qip.idempotency.enabled"}, havingValue="false", matchIfMissing=false)
@OnBeforeDeploymentContextCreated
public class IdempotencyStateCheckAction
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(IdempotencyStateCheckAction.class);

    @Override
    public boolean applicableTo(ElementProperties properties) {
        String elementType = properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString(elementType);
        return (ChainElementType.HTTP_TRIGGER.equals((Object)chainElementType) || ChainElementType.KAFKA_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.RABBITMQ_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.ASYNCAPI_TRIGGER.equals((Object)chainElementType)) && Boolean.valueOf(properties.getProperties().get("idempotencyEnabled")) != false;
    }

    @Override
    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        throw new RuntimeException("Idempotency support is disabled on environment");
    }
}

