/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.idempotency;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import org.apache.camel.Exchange;
import org.apache.camel.component.redis.processor.idempotent.RedisStringIdempotentRepository;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotencyRecord;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotencyRecordStatus;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class RedisIdempotentRepository
extends RedisStringIdempotentRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisIdempotentRepository.class);
    private final IdempotentRepositoryParameters keyParameters;
    private final ObjectMapper objectMapper;
    private final ValueOperations<String, String> valueOperations;

    public RedisIdempotentRepository(RedisTemplate<String, String> redisTemplate, ObjectMapper objectMapper, IdempotentRepositoryParameters keyParameters) {
        super(redisTemplate, null);
        this.setExpiry((long)keyParameters.getTtl());
        this.objectMapper = objectMapper;
        this.keyParameters = keyParameters;
        this.valueOperations = redisTemplate.opsForValue();
    }

    protected String createRedisKey(String idempotencyKey) {
        return this.keyParameters.getKeyStrategy().buildRepositoryKey(idempotencyKey);
    }

    public boolean add(Exchange exchange, String key) {
        String redisKey = this.createRedisKey(key);
        String value = this.createRedisValue(exchange);
        if (this.keyParameters.getTtl() > 0) {
            Duration expiry = Duration.ofSeconds(this.keyParameters.getTtl());
            return this.valueOperations.setIfAbsent((Object)redisKey, (Object)value, expiry);
        }
        return this.valueOperations.setIfAbsent((Object)redisKey, (Object)value);
    }

    protected String createRedisValue(Exchange exchange) {
        IdempotencyRecord record = IdempotencyRecord.builder().status(IdempotencyRecordStatus.RECEIVED).createdAt(Timestamp.from(Instant.now())).build();
        try {
            return this.objectMapper.writeValueAsString((Object)record);
        }
        catch (JsonProcessingException exception) {
            log.error("Failed to create idempotency Redis value", (Throwable)exception);
            return null;
        }
    }

    public void clear() {
    }
}

