/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.apache.camel.spi.IdempotentRepository;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryParameters;
import org.qubership.integration.platform.engine.camel.idempotency.RedisIdempotentRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@AutoConfiguration
@Import(value={org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class})
@ConditionalOnProperty(value={"qip.idempotency.enabled"}, havingValue="true", matchIfMissing=true)
public class RedisAutoConfiguration {
    @Bean
    RedisTemplate<String, String> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(name={"idempotentRepositoryFactory"})
    Function<IdempotentRepositoryParameters, IdempotentRepository> idempotentRepository(RedisTemplate<String, String> redisTemplate, ObjectMapper objectMapper) {
        return keyParameters -> new RedisIdempotentRepository(redisTemplate, objectMapper, keyParameters);
    }
}

