/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Status of the element or session")
public enum ExecutionStatus {
    IN_PROGRESS,
    COMPLETED_NORMALLY,
    COMPLETED_WITH_WARNINGS,
    COMPLETED_WITH_ERRORS,
    CANCELLED_OR_UNKNOWN;


    public static ExecutionStatus computeHigherPriorityStatus(ExecutionStatus firstStatus, ExecutionStatus secondStatus) {
        if (IN_PROGRESS.equals((Object)firstStatus) || IN_PROGRESS.equals((Object)secondStatus)) {
            return IN_PROGRESS;
        }
        if (COMPLETED_WITH_ERRORS.equals((Object)firstStatus) || COMPLETED_WITH_ERRORS.equals((Object)secondStatus)) {
            return COMPLETED_WITH_ERRORS;
        }
        if (COMPLETED_WITH_WARNINGS.equals((Object)firstStatus) || COMPLETED_WITH_WARNINGS.equals((Object)secondStatus)) {
            return COMPLETED_WITH_WARNINGS;
        }
        return COMPLETED_NORMALLY;
    }

    public static String formatToLogStatus(ExecutionStatus status) {
        if (status == null) {
            return "";
        }
        String[] words = status.name().split("_");
        StringBuilder formattedString = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formattedString.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formattedString.toString().trim();
    }
}

