/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.CamelEvent;
import org.qubership.integration.platform.engine.camel.context.propagation.CamelExchangeContextPropagation;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.errorhandling.ChainExecutionTimeoutException;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.Session;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.logging.ElementRetryProperties;
import org.qubership.integration.platform.engine.model.logging.LogLoggingLevel;
import org.qubership.integration.platform.engine.model.logging.SessionsLoggingLevel;
import org.qubership.integration.platform.engine.model.sessionsreporting.EventSourceType;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.qubership.integration.platform.engine.service.ExchangePropertyService;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.debugger.kafkareporting.SessionsKafkaReportingService;
import org.qubership.integration.platform.engine.service.debugger.logging.ChainLogger;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsService;
import org.qubership.integration.platform.engine.service.debugger.sessions.SessionsService;
import org.qubership.integration.platform.engine.service.debugger.tracing.TracingService;
import org.qubership.integration.platform.engine.service.debugger.util.DebuggerUtils;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.qubership.integration.platform.engine.util.CheckpointUtils;
import org.qubership.integration.platform.engine.util.IdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CamelDebugger
extends DefaultDebugger {
    private static final Logger log = LoggerFactory.getLogger(CamelDebugger.class);
    private final ServerConfiguration serverConfiguration;
    private final TracingService tracingService;
    private final CheckpointSessionService checkpointSessionService;
    private final MetricsService metricsService;
    private final ChainLogger chainLogger;
    private final Optional<SessionsKafkaReportingService> sessionsKafkaReportingService;
    private final SessionsService sessionsService;
    private final PayloadExtractor payloadExtractor;
    private final VariablesService variablesService;
    private final CamelDebuggerPropertiesService propertiesService;
    private final Optional<CamelExchangeContextPropagation> exchangeContextPropagation;
    private final ExchangePropertyService exchangePropertyService;
    private String deploymentId;

    @Autowired
    public CamelDebugger(ServerConfiguration serverConfiguration, TracingService tracingService, CheckpointSessionService checkpointSessionService, MetricsService metricsService, ChainLogger chainLogger, Optional<SessionsKafkaReportingService> sessionsKafkaReportingService, SessionsService sessionsService, PayloadExtractor payloadExtractor, VariablesService variablesService, CamelDebuggerPropertiesService propertiesService, Optional<CamelExchangeContextPropagation> exchangeContextPropagation, ExchangePropertyService exchangePropertyService) {
        this.serverConfiguration = serverConfiguration;
        this.tracingService = tracingService;
        this.checkpointSessionService = checkpointSessionService;
        this.metricsService = metricsService;
        this.chainLogger = chainLogger;
        this.sessionsKafkaReportingService = sessionsKafkaReportingService;
        this.sessionsService = sessionsService;
        this.payloadExtractor = payloadExtractor;
        this.variablesService = variablesService;
        this.propertiesService = propertiesService;
        this.exchangeContextPropagation = exchangeContextPropagation;
        this.exchangePropertyService = exchangePropertyService;
    }

    public boolean onEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
        CamelDebuggerProperties dbgProperties = this.getRelatedProperties(exchange);
        CamelEvent.ExchangeEvent exchangeEvent = event;
        Objects.requireNonNull(exchangeEvent);
        CamelEvent.ExchangeEvent exchangeEvent2 = exchangeEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CamelEvent.ExchangeCreatedEvent.class, CamelEvent.StepStartedEvent.class, CamelEvent.StepCompletedEvent.class, CamelEvent.StepFailedEvent.class, CamelEvent.ExchangeCompletedEvent.class, CamelEvent.ExchangeFailedEvent.class}, (Object)exchangeEvent2, n)) {
            case 0: {
                CamelEvent.ExchangeCreatedEvent ev = (CamelEvent.ExchangeCreatedEvent)exchangeEvent2;
                this.exchangeCreated(exchange, dbgProperties);
                break;
            }
            case 1: {
                CamelEvent.StepStartedEvent ev = (CamelEvent.StepStartedEvent)exchangeEvent2;
                this.stepStarted(exchange, (CamelEvent.StepEvent)event, dbgProperties);
                break;
            }
            case 2: {
                CamelEvent.StepCompletedEvent ev = (CamelEvent.StepCompletedEvent)exchangeEvent2;
                this.stepFinished(exchange, (CamelEvent.StepEvent)event, dbgProperties, false);
                break;
            }
            case 3: {
                CamelEvent.StepFailedEvent ev = (CamelEvent.StepFailedEvent)exchangeEvent2;
                this.stepFinished(exchange, (CamelEvent.StepEvent)event, dbgProperties, true);
                break;
            }
            case 4: {
                CamelEvent.ExchangeCompletedEvent ev = (CamelEvent.ExchangeCompletedEvent)exchangeEvent2;
                this.exchangeFinished(exchange);
                break;
            }
            case 5: {
                CamelEvent.ExchangeFailedEvent ev = (CamelEvent.ExchangeFailedEvent)exchangeEvent2;
                this.exchangeFinished(exchange);
                break;
            }
        }
        return super.onEvent(exchange, event);
    }

    public boolean beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
        CamelDebuggerProperties dbgProperties = this.getRelatedProperties(exchange);
        this.initOrActivatePropagatedContext(exchange);
        SessionsLoggingLevel sessionLevel = dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange);
        LogLoggingLevel logLoggingLevel = dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel();
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        String nodeId = definition.getId();
        boolean sessionShouldBeLogged = (Boolean)exchange.getProperty("internalProperty_sessionShouldBeLogged", Boolean.class);
        this.setLoggerContext(exchange, dbgProperties, nodeId);
        if (exchange.getProperty("internalProperty_elementExecutionMap") == null) {
            exchange.setProperty("internalProperty_elementExecutionMap", new ConcurrentHashMap());
        }
        if (CamelConstants.CUSTOM_STEP_ID_PATTERN.matcher(nodeId).matches()) {
            String stepName = DebuggerUtils.getStepNameFormatted((String)nodeId);
            String elementId = DebuggerUtils.getStepChainElementId((String)nodeId);
            ChainElementType elementType = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(elementId).get("elementType")));
            this.logBeforeStepStarted(exchange, dbgProperties, stepName, elementId, elementType);
            this.handleElementBeforeProcess(exchange, dbgProperties, elementId, elementType);
        }
        if (IdentifierUtils.isValidUUID((String)nodeId)) {
            if (this.tracingService.isTracingEnabled() && dbgProperties.containsElementProperty(nodeId)) {
                this.tracingService.addElementTracingTags(exchange, nodeId, dbgProperties);
            }
            ChainElementType chainElementType = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(nodeId).get("elementType")));
            Map headersForLogging = Collections.emptyMap();
            Map exchangePropertiesForLogging = Collections.emptyMap();
            String bodyForLogging = null;
            boolean isElementForSessionsLevel = ChainElementType.isElementForInfoSessionsLevel((ChainElementType)chainElementType);
            if (sessionShouldBeLogged && SessionsLoggingLevel.hasPayload((SessionsLoggingLevel)sessionLevel, (boolean)isElementForSessionsLevel) || logLoggingLevel.isInfoLevel()) {
                headersForLogging = this.payloadExtractor.extractHeadersForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                bodyForLogging = this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                exchangePropertiesForLogging = this.payloadExtractor.extractExchangePropertiesForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
            }
            if (!(definition instanceof StepDefinition)) {
                String sessionElementId = UUID.randomUUID().toString();
                switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$logging$SessionsLoggingLevel[sessionLevel.ordinal()]) {
                    case 1: {
                        this.putElementToSingleElCache(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, exchangePropertiesForLogging);
                        break;
                    }
                    case 2: {
                        this.putElementToSingleElCache(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, exchangePropertiesForLogging);
                        if (!isElementForSessionsLevel) break;
                    }
                    case 3: {
                        if (!sessionShouldBeLogged) break;
                        this.sessionsService.logSessionElementBefore(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, this.payloadExtractor.extractContextForLogging(dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()), exchangePropertiesForLogging);
                        break;
                    }
                }
            }
            try {
                this.chainLogger.logBeforeProcess(exchange, dbgProperties, bodyForLogging, headersForLogging, exchangePropertiesForLogging, nodeId);
            }
            catch (Exception e) {
                log.warn("Failed to log before process", (Throwable)e);
            }
        }
        return super.beforeProcess(exchange, processor, definition);
    }

    public boolean afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
        CamelDebuggerProperties dbgProperties = this.getRelatedProperties(exchange);
        this.checkExecutionTimeout(exchange);
        this.initOrActivatePropagatedContext(exchange);
        SessionsLoggingLevel actualSessionLevel = dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange);
        LogLoggingLevel logLoggingLevel = dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel();
        String nodeId = definition.getId();
        this.setLoggerContext(exchange, dbgProperties, nodeId);
        boolean sessionShouldBeLogged = (Boolean)exchange.getProperty("internalProperty_sessionShouldBeLogged", Boolean.class);
        if (IdentifierUtils.isValidUUID((String)nodeId)) {
            Map elementProperties = dbgProperties.getElementProperty(nodeId);
            ChainElementType chainElementType = ChainElementType.fromString((String)((String)elementProperties.get("elementType")));
            Map headersForLogging = Collections.emptyMap();
            Map exchangePropertiesForLogging = Collections.emptyMap();
            String bodyForLogging = null;
            boolean isElementForSessionsLevel = ChainElementType.isElementForInfoSessionsLevel((ChainElementType)chainElementType);
            this.setFailedElementId(exchange, elementProperties);
            if (sessionShouldBeLogged && SessionsLoggingLevel.hasPayload((SessionsLoggingLevel)actualSessionLevel, (boolean)isElementForSessionsLevel) || logLoggingLevel.isInfoLevel() || DebuggerUtils.isFailedOperation((Exchange)exchange)) {
                headersForLogging = this.payloadExtractor.extractHeadersForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                bodyForLogging = this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                exchangePropertiesForLogging = this.payloadExtractor.extractExchangePropertiesForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
            }
            switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$logging$SessionsLoggingLevel[actualSessionLevel.ordinal()]) {
                case 2: {
                    if (!isElementForSessionsLevel) break;
                }
                case 3: {
                    if (!sessionShouldBeLogged) break;
                    String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
                    String splitIdChain = (String)exchange.getProperty("internalProperty_splitIdChain");
                    String sessionElementId = (String)((Map)exchange.getProperty("internalProperty_elementExecutionMap")).get(DebuggerUtils.getNodeIdForExecutionMap((String)nodeId, (String)splitIdChain));
                    if (sessionElementId == null) {
                        sessionElementId = (String)((Map)exchange.getProperty("internalProperty_elementExecutionMap")).get(nodeId);
                    }
                    this.sessionsService.logSessionElementAfter(exchange, null, sessionId, sessionElementId, bodyForLogging, headersForLogging, this.payloadExtractor.extractContextForLogging(dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()), exchangePropertiesForLogging);
                    break;
                }
            }
            try {
                this.chainLogger.logAfterProcess(exchange, dbgProperties, bodyForLogging, headersForLogging, exchangePropertiesForLogging, nodeId, timeTaken);
            }
            catch (Exception e) {
                log.warn("Failed to log after process", (Throwable)e);
            }
        }
        return super.afterProcess(exchange, processor, definition, timeTaken);
    }

    private void exchangeCreated(Exchange exchange, CamelDebuggerProperties dbgProperties) {
        this.initOrActivatePropagatedContext(exchange);
        DebuggerUtils.initInternalExchangeVariables((Exchange)exchange);
        this.variablesService.injectVariablesToExchangeProperties(exchange.getProperties());
        this.exchangeStarted(exchange, dbgProperties);
        if (this.tracingService.isTracingEnabled()) {
            this.tracingService.addChainTracingTags(exchange, dbgProperties);
        }
    }

    private void exchangeStarted(Exchange exchange, CamelDebuggerProperties dbgProperties) {
        Map exchanges;
        String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            String started = LocalDateTime.now().toString();
            Long startedMillis = System.currentTimeMillis();
            exchange.setProperty("internalProperty_sessionId", (Object)sessionId);
            exchange.setProperty("internalProperty_sessionShouldBeLogged", (Object)this.sessionsService.sessionShouldBeLogged());
            exchange.setProperty("internalProperty_isMainExchange", (Object)true);
            exchange.setProperty("internalProperty_startTime", (Object)started);
            exchange.setProperty("internalProperty_startTimeMs", (Object)startedMillis);
            ((ConcurrentHashMap)exchange.getProperty("internalProperty_exchanges", ConcurrentHashMap.class)).put(sessionId, new ConcurrentHashMap());
            String parentSessionId = null;
            CheckpointUtils.CheckpointInfo checkpointInfo = CheckpointUtils.extractTriggeredCheckpointInfo((Exchange)exchange);
            if (checkpointInfo != null) {
                Optional<Checkpoint> checkpoint = Optional.ofNullable(this.checkpointSessionService.findCheckpoint(checkpointInfo.sessionId(), checkpointInfo.chainId(), checkpointInfo.checkpointElementId()));
                parentSessionId = checkpoint.map(Checkpoint::getSession).map(SessionInfo::getId).orElse(null);
            }
            Session session = this.sessionsService.startSession(exchange, dbgProperties, sessionId, parentSessionId, started, this.getCurrentDomain(), this.getCurrentEngineAddress());
            if (dbgProperties.getDeploymentInfo().isContainsCheckpointElements()) {
                this.checkpointSessionService.saveSession(new SessionInfo(session));
            }
            String originalSessionId = this.checkpointSessionService.findOriginalSessionInfo(parentSessionId).map(SessionInfo::getId).orElse(parentSessionId);
            CheckpointUtils.setSessionProperties((Exchange)exchange, (String)parentSessionId, (String)originalSessionId);
            if (dbgProperties.getRuntimeProperties(exchange).isDptEventsEnabled() && this.sessionsKafkaReportingService.isPresent()) {
                ((SessionsKafkaReportingService)this.sessionsKafkaReportingService.get()).addToQueue(exchange, dbgProperties, sessionId, originalSessionId, parentSessionId, EventSourceType.SESSION_STARTED);
            }
            exchange.setProperty("internalProperty_threadSessionStatuses", new HashMap());
        }
        if ((exchanges = (Map)((Map)exchange.getProperty("internalProperty_exchanges", Map.class)).get(sessionId)) != null) {
            exchanges.put(exchange.getExchangeId(), exchange);
        }
        exchange.setProperty("TraceMe", (Object)Boolean.valueOf((String)exchange.getMessage().getHeader("TraceMe", (Object)"", String.class)));
    }

    private void exchangeFinished(Exchange exchange) {
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        Map exchanges = (Map)((Map)exchange.getProperty("internalProperty_exchanges", Map.class)).get(sessionId);
        if (exchanges != null) {
            exchanges.remove(exchange.getExchangeId());
        }
        log.debug("Exchange finished in thread '{}'", (Object)Thread.currentThread().getName());
    }

    private void stepStarted(Exchange exchange, CamelEvent.StepEvent event, CamelDebuggerProperties dbgProperties) {
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        String fullStepId = event.getStepId();
        String stepId = DebuggerUtils.getNodeIdFormatted((String)fullStepId);
        String stepName = DebuggerUtils.getStepNameFormatted((String)fullStepId);
        String stepChainElementId = DebuggerUtils.getStepChainElementId((String)fullStepId);
        String sessionElementId = UUID.randomUUID().toString();
        ChainElementType elementType = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(stepId).get("elementType")));
        boolean sessionShouldBeLogged = (Boolean)exchange.getProperty("internalProperty_sessionShouldBeLogged", Boolean.class);
        this.metricsService.processElementStartMetrics(exchange, dbgProperties, stepId, stepName, elementType);
        switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$logging$SessionsLoggingLevel[dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange).ordinal()]) {
            case 1: {
                this.sessionsService.putStepElementToSingleElCache(exchange, dbgProperties, sessionId, sessionElementId, stepName, stepChainElementId);
                break;
            }
            case 2: {
                if (!ChainElementType.isElementForInfoSessionsLevel((ChainElementType)elementType)) break;
            }
            case 3: {
                if (!sessionShouldBeLogged) break;
                this.sessionsService.logSessionStepElementBefore(exchange, dbgProperties, sessionId, sessionElementId, stepName, stepChainElementId);
                String executionStepId = stepName;
                if (ChainElementType.isWrappedInStepElement((ChainElementType)elementType)) {
                    executionStepId = DebuggerUtils.getNodeIdForExecutionMap((String)executionStepId, (String)((String)exchange.getProperty("internalProperty_splitIdChain")));
                }
                ((Map)exchange.getProperty("internalProperty_elementExecutionMap")).put(executionStepId, sessionElementId);
                break;
            }
        }
        ((Deque)exchange.getProperty("internalProperty_steps", Deque.class)).push(sessionElementId);
    }

    private void stepFinished(Exchange exchange, CamelEvent.StepEvent event, CamelDebuggerProperties dbgProperties, boolean failed) {
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        String fullStepId = event.getStepId();
        String stepId = DebuggerUtils.getNodeIdFormatted((String)fullStepId);
        String stepName = DebuggerUtils.getStepNameFormatted((String)fullStepId);
        ChainElementType elementType = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(stepId).get("elementType")));
        boolean sessionShouldBeLogged = (Boolean)exchange.getProperty("internalProperty_sessionShouldBeLogged", Boolean.class);
        this.metricsService.processElementFinishMetrics(exchange, dbgProperties, stepId, stepName, elementType, failed);
        this.setFailedElementId(exchange, dbgProperties.getElementProperty(stepId));
        this.setLoggerContext(exchange, dbgProperties, stepId);
        this.logAfterStepFinished(exchange, dbgProperties, stepName, stepId, elementType);
        switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$logging$SessionsLoggingLevel[dbgProperties.getRuntimeProperties(exchange).calculateSessionLevel(exchange).ordinal()]) {
            case 2: {
                if (!ChainElementType.isElementForInfoSessionsLevel((ChainElementType)elementType)) break;
            }
            case 3: {
                if (!sessionShouldBeLogged) break;
                String sessionElementId = (String)((Deque)exchange.getProperty("internalProperty_steps")).pop();
                if (failed) {
                    DebuggerUtils.removeStepPropertyFromAllExchanges((Exchange)exchange, (String)sessionElementId);
                }
                this.sessionsService.logSessionElementAfter(exchange, null, sessionId, sessionElementId, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                break;
            }
        }
        if (!failed && dbgProperties.getRuntimeProperties(exchange).isDptEventsEnabled() && elementType == ChainElementType.CHECKPOINT && !((Boolean)exchange.getProperty("internalProperty_isCheckpointTriggerStep", (Object)false, Boolean.class)).booleanValue() && this.sessionsKafkaReportingService.isPresent()) {
            String parentSessionId = (String)exchange.getProperty("internalProperty_parentSessionId", String.class);
            String originalSessionId = (String)exchange.getProperty("internalProperty_originalSessionId", String.class);
            ((SessionsKafkaReportingService)this.sessionsKafkaReportingService.get()).addToQueue(exchange, dbgProperties, sessionId, originalSessionId, parentSessionId, EventSourceType.SESSION_CHECKPOINT_PASSED);
        }
    }

    private void logBeforeStepStarted(Exchange exchange, CamelDebuggerProperties dbgProperties, String stepName, String elementId, ChainElementType elementType) {
        LogLoggingLevel logLoggingLevel = dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel();
        switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[elementType.ordinal()]) {
            case 1: {
                if ("Request attempt".equals(stepName)) {
                    if (!logLoggingLevel.isInfoLevel()) break;
                    this.chainLogger.logRequestAttempt(exchange, this.getElementRetryProperties(dbgProperties, elementId), elementId);
                    break;
                }
                if (!"Request".equals(stepName) || !logLoggingLevel.isInfoLevel()) break;
                Map headersForLogging = this.payloadExtractor.extractHeadersForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                String bodyForLogging = DebuggerUtils.chooseLogPayload((Exchange)exchange, (String)this.payloadExtractor.extractBodyForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()), (CamelDebuggerProperties)dbgProperties);
                Map exchangePropertiesForLogging = this.payloadExtractor.extractExchangePropertiesForLogging(exchange, dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled());
                this.chainLogger.logRequest(exchange, bodyForLogging, headersForLogging, exchangePropertiesForLogging, (String)dbgProperties.getElementProperty(elementId).get("externalServiceName"), (String)dbgProperties.getElementProperty(elementId).get("externalServiceEnvName"));
                break;
            }
        }
    }

    private void handleElementBeforeProcess(Exchange exchange, CamelDebuggerProperties dbgProperties, String elementId, ChainElementType elementType) {
        switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[elementType.ordinal()]) {
            case 1: {
                Map elementProperties = dbgProperties.getElementProperty(elementId);
                exchange.setProperty("external-service-name", elementProperties.get("externalServiceName"));
                exchange.setProperty("external-service-environment-name", elementProperties.get("externalServiceEnvName"));
                break;
            }
        }
    }

    public void logAfterStepFinished(Exchange exchange, CamelDebuggerProperties dbgProperties, String stepName, String elementId, ChainElementType elementType) {
        LogLoggingLevel logLoggingLevel = dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel();
        switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[elementType.ordinal()]) {
            case 1: {
                if (!"Request attempt".equals(stepName) || !logLoggingLevel.isWarnLevel()) break;
                this.chainLogger.logRetryRequestAttempt(exchange, this.getElementRetryProperties(dbgProperties, elementId), elementId);
                break;
            }
        }
    }

    public void finishCheckpointSession(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, ExecutionStatus executionStatus, long duration) {
        SessionInfo checkpointSession = this.checkpointSessionService.findSession(sessionId);
        if (checkpointSession != null) {
            if (executionStatus == ExecutionStatus.COMPLETED_WITH_ERRORS) {
                checkpointSession.setExecutionStatus(executionStatus);
                checkpointSession.setFinished(Timestamp.from(new Date().toInstant()));
                checkpointSession.setDuration(duration);
                this.checkpointSessionService.saveSession(checkpointSession);
                this.setLoggerContext(exchange, dbgProperties, null);
                this.chainLogger.warn("Chain session completed with errors. You can retry the session with checkpoint elements", new Object[0]);
            } else {
                try {
                    boolean isRootSession = exchange.getProperty("internalProperty_parentSessionId", String.class) == null;
                    this.checkpointSessionService.removeAllRelatedCheckpoints(checkpointSession.getId(), isRootSession);
                }
                catch (Exception e) {
                    log.error("Failed to run checkpoint cleanup", (Throwable)e);
                }
            }
        }
    }

    private void initOrActivatePropagatedContext(Exchange exchange) {
        Map contextSnapshot = (Map)exchange.getProperty("internalProperty_requestContextPropagationSnapshot");
        Map exchangeHeaders = exchange.getMessage().getHeaders();
        long currentThreadId = Thread.currentThread().getId();
        if (contextSnapshot != null) {
            Set contextInitMarkers = this.getContextInitMarkers(exchange);
            if (!contextInitMarkers.contains(currentThreadId)) {
                log.debug("Detected new thread '{}' with empty context", (Object)Thread.currentThread().getName());
                this.exchangeContextPropagation.ifPresent(bean -> bean.activateContextSnapshot(contextSnapshot));
                contextInitMarkers.add(currentThreadId);
            }
        } else {
            this.exchangeContextPropagation.ifPresent(bean -> bean.initRequestContext(exchangeHeaders));
            this.getContextInitMarkers(exchange).add(currentThreadId);
            log.debug("New exchange created in thread '{}'", (Object)Thread.currentThread().getName());
            this.exchangeContextPropagation.ifPresent(bean -> {
                Object authorization = exchangeHeaders.get("Authorization");
                bean.removeContextHeaders(exchangeHeaders);
                if (Objects.nonNull(authorization)) {
                    exchangeHeaders.put("Authorization", authorization);
                }
            });
            Map snapshot = this.exchangeContextPropagation.isPresent() ? ((CamelExchangeContextPropagation)this.exchangeContextPropagation.get()).createContextSnapshot() : Collections.emptyMap();
            exchange.setProperty("internalProperty_requestContextPropagationSnapshot", (Object)snapshot);
            this.exchangePropertyService.initAdditionalExchangeProperties(exchange);
        }
    }

    private Set<Long> getContextInitMarkers(Exchange exchange) {
        HashSet contextInitMarkers = (HashSet)exchange.getProperty("internalProperty_contextInitMarkers", Set.class);
        if (contextInitMarkers == null) {
            HashSet newSet = new HashSet();
            exchange.setProperty("internalProperty_contextInitMarkers", newSet);
            contextInitMarkers = newSet;
        }
        return contextInitMarkers;
    }

    private void putElementToSingleElCache(Exchange exchange, CamelDebuggerProperties dbgProperties, String sessionId, String sessionElementId, String nodeId, String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging) {
        this.sessionsService.putElementToSingleElCache(exchange, dbgProperties, sessionId, sessionElementId, nodeId, bodyForLogging, headersForLogging, this.payloadExtractor.extractContextForLogging(dbgProperties.getMaskedFields(), dbgProperties.getRuntimeProperties(exchange).isMaskingEnabled()), exchangePropertiesForLogging);
    }

    private void setLoggerContext(Exchange exchange, CamelDebuggerProperties dbgProperties, @Nullable String nodeId) {
        this.chainLogger.setLoggerContext(exchange, dbgProperties, nodeId, this.tracingService.isTracingEnabled());
    }

    private String getCurrentDomain() {
        return this.serverConfiguration.getDomain();
    }

    private String getCurrentEngineAddress() {
        return this.serverConfiguration.getHost();
    }

    public CamelDebuggerProperties getRelatedProperties(Exchange exchange) {
        return this.propertiesService.getProperties(exchange, this.deploymentId);
    }

    public CamelDebuggerProperties getRelatedProperties() {
        return this.propertiesService.getActualProperties(this.deploymentId);
    }

    private void setFailedElementId(Exchange exchange, Map<String, String> elementProperties) {
        if (Boolean.TRUE.equals(exchange.getProperty("internalProperty_elementFailed", Boolean.class))) {
            exchange.setProperty("failed-element-name", (Object)elementProperties.get("elementName"));
            exchange.setProperty("failed-element-id", (Object)elementProperties.get("elementId"));
            exchange.setProperty("internalProperty_element_warning", (Object)Boolean.FALSE);
            DebuggerUtils.setOverallWarning((Exchange)exchange, (boolean)false);
        } else if (DebuggerUtils.isFailedOperation((Exchange)exchange) && exchange.getProperties().get("internalProperty_lastException") != exchange.getException()) {
            exchange.getProperties().put("internalProperty_lastException", exchange.getException());
            exchange.getProperties().put("internalProperty_laseExceptionErrorCode", ErrorCode.match((Throwable)exchange.getException()));
            exchange.setProperty("failed-element-name", (Object)elementProperties.get("elementName"));
            exchange.setProperty("failed-element-id", (Object)elementProperties.get("elementId"));
            exchange.setProperty("internalProperty_element_warning", (Object)Boolean.FALSE);
            DebuggerUtils.setOverallWarning((Exchange)exchange, (boolean)false);
        }
    }

    private void checkExecutionTimeout(Exchange exchange) {
        long timeoutAfter = (Long)exchange.getProperty("internalProperty_chainSessionTimeoutAfter", (Object)0, Long.class);
        if (timeoutAfter <= 0L) {
            return;
        }
        long startTime = (Long)exchange.getProperty("internalProperty_startTimeMs", Long.class);
        long duration = System.currentTimeMillis() - startTime;
        boolean isTimedOut = (Boolean)exchange.getProperty("internalProperty_chainSessionTimedOut", (Object)false, Boolean.class);
        if (duration > timeoutAfter && !isTimedOut) {
            ChainExecutionTimeoutException exception = new ChainExecutionTimeoutException("Chain execution timed out after " + duration + " ms. Desired limit is " + timeoutAfter + " ms.");
            exchange.setProperty("internalProperty_chainSessionTimedOut", (Object)true);
            exchange.setException((Throwable)exception);
        }
    }

    private ElementRetryProperties getElementRetryProperties(CamelDebuggerProperties dbgProperties, String elementId) {
        String retryCountString = null;
        String retryDelayString = null;
        try {
            Map elementProperties = Optional.ofNullable(dbgProperties.getElementProperty(elementId)).orElse(Collections.emptyMap());
            retryCountString = this.variablesService.injectVariables((String)elementProperties.get("retryCount"));
            retryDelayString = this.variablesService.injectVariables((String)elementProperties.get("retryDelay"));
        }
        catch (Exception e) {
            log.error("Failed to set retry parameters for elementId: {}", (Object)elementId, (Object)e);
        }
        return new ElementRetryProperties(retryCountString, retryDelayString);
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }
}

