/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.JsonMessageValidator;
import org.qubership.integration.platform.engine.errorhandling.ResponseValidationException;
import org.qubership.integration.platform.engine.errorhandling.ValidationException;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.springframework.stereotype.Component;

@Component
public class ResponseValidationProcessor
implements Processor {
    private final JsonMessageValidator validator;

    public ResponseValidationProcessor(JsonMessageValidator validator) {
        this.validator = validator;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.validate(exchange);
        }
        catch (ValidationException e) {
            throw new ResponseValidationException(e.getMessage());
        }
    }

    private void validate(Exchange exchange) {
        this.validateJSON(exchange);
    }

    private void validateJSON(Exchange exchange) {
        String validationSchema = (String)exchange.getProperty("internalProperty_validationSchema", String.class);
        if (!StringUtils.isBlank((CharSequence)validationSchema)) {
            String inputJsonMessage = MessageHelper.extractBody(exchange);
            this.validator.validate(inputJsonMessage, validationSchema);
        }
    }
}

