/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import java.util.function.Function;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryKeyStrategy;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotentRepositoryParameters;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
@ConditionalOnProperty(value={"qip.idempotency.enabled"}, havingValue="true", matchIfMissing=true)
public class IdempotentConsumerDependencyBinder
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(IdempotentConsumerDependencyBinder.class);
    private final Function<IdempotentRepositoryParameters, IdempotentRepository> idempotentRepositoryFactory;

    @Autowired
    public IdempotentConsumerDependencyBinder(Function<IdempotentRepositoryParameters, IdempotentRepository> idempotentRepositoryFactory) {
        this.idempotentRepositoryFactory = idempotentRepositoryFactory;
    }

    @Override
    public boolean applicableTo(ElementProperties properties) {
        String elementType = properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString(elementType);
        return (ChainElementType.HTTP_TRIGGER.equals((Object)chainElementType) || ChainElementType.KAFKA_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.RABBITMQ_TRIGGER_2.equals((Object)chainElementType) || ChainElementType.ASYNCAPI_TRIGGER.equals((Object)chainElementType) || ChainElementType.JMS_TRIGGER.equals((Object)chainElementType)) && Boolean.valueOf(properties.getProperties().get("idempotencyEnabled")) != false;
    }

    @Override
    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        String elementId = properties.getElementId();
        IdempotentRepositoryParameters keyParameters = IdempotentRepositoryParameters.builder().ttl(Integer.valueOf(properties.getProperties().get("expiry"))).keyStrategy(this.getKeyStrategy(properties, deploymentInfo)).build();
        IdempotentRepository idempotentRepository = this.idempotentRepositoryFactory.apply(keyParameters);
        context.getRegistry().bind(elementId, (Object)idempotentRepository);
    }

    private IdempotentRepositoryKeyStrategy getKeyStrategy(ElementProperties properties, DeploymentInfo deploymentInfo) {
        return key -> key;
    }
}

