/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import jakarta.annotation.PostConstruct;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.qubership.integration.platform.engine.configuration.ApplicationAutoConfiguration;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineInfo;
import org.qubership.integration.platform.engine.util.EngineDomainUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServerConfiguration.class);
    private final ApplicationAutoConfiguration applicationConfiguration;
    private String host;
    @Value(value="${server.port}")
    private int port;
    private final String domain;

    public ServerConfiguration(ApplicationAutoConfiguration applicationConfiguration, EngineDomainUtils engineDomainUtils) {
        this.applicationConfiguration = applicationConfiguration;
        this.domain = engineDomainUtils.extractEngineDomain(applicationConfiguration.getMicroserviceName());
    }

    @PostConstruct
    public void initHost() {
        this.host = this.getCurrentHost();
    }

    public EngineInfo getEngineInfo() {
        return EngineInfo.builder().domain(this.domain).engineDeploymentName(this.applicationConfiguration.getDeploymentName()).host(this.host).build();
    }

    private String getCurrentHost() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("Can't identify current host address");
            return "";
        }
    }

    public ApplicationAutoConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

