/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.camel.kafkacustom;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.springboot.KafkaComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.qubership.integration.platform.engine.camel.components.kafka.KafkaCustomComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, KafkaComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.kafka"})
public class KafkaCustomComponentConfiguration {
    private final KafkaComponentConfiguration configuration;

    @Autowired
    public KafkaCustomComponentConfiguration(KafkaComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Bean
    public ComponentCustomizer kafkaCustomComponentCustomizer() {
        return ComponentCustomizer.builder(KafkaCustomComponent.class).build(component -> {
            KafkaConfiguration config = component.getConfiguration();
            config.setSslTruststoreLocation(this.configuration.getSslTruststoreLocation());
            config.setSslTruststorePassword(this.configuration.getSslTruststorePassword());
            config.setSslTruststoreType(this.configuration.getSslTruststoreType());
        });
    }
}

