/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.qubership.integration.platform.engine.model.Session;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.service.ExecutionStatus;

@Entity(name="sessions_info")
public class SessionInfo {
    @Id
    private String id;
    private Timestamp started;
    private Timestamp finished;
    private long duration;
    private ExecutionStatus executionStatus;
    private String chainId;
    private String chainName;
    private String domain;
    private String engineAddress;
    private String loggingLevel;
    private String snapshotName;
    private String correlationId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original_session_id", referencedColumnName="id")
    private SessionInfo parentSession;
    @OneToMany(orphanRemoval=true, mappedBy="session", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Checkpoint> checkpoints = new LinkedList<Checkpoint>();

    public SessionInfo(Session session) {
        this.setId(session.getId());
        this.setStarted(Timestamp.from(new Date().toInstant()));
        this.setDuration(session.getDuration());
        this.setExecutionStatus(session.getExecutionStatus());
        this.setChainId(session.getChainId());
        this.setChainName(session.getChainName());
        this.setDomain(session.getDomain());
        this.setEngineAddress(session.getEngineAddress());
        this.setLoggingLevel(session.getLoggingLevel());
        this.setSnapshotName(session.getSnapshotName());
        this.setCorrelationId(session.getCorrelationId());
    }

    public void assignCheckpoint(Checkpoint checkpoint) {
        checkpoint.setSession(this);
        this.getCheckpoints().add(checkpoint);
    }

    public String getId() {
        return this.id;
    }

    public Timestamp getStarted() {
        return this.started;
    }

    public Timestamp getFinished() {
        return this.finished;
    }

    public long getDuration() {
        return this.duration;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEngineAddress() {
        return this.engineAddress;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public SessionInfo getParentSession() {
        return this.parentSession;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStarted(Timestamp started) {
        this.started = started;
    }

    public void setFinished(Timestamp finished) {
        this.finished = finished;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEngineAddress(String engineAddress) {
        this.engineAddress = engineAddress;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setParentSession(SessionInfo parentSession) {
        this.parentSession = parentSession;
    }

    public void setCheckpoints(List<Checkpoint> checkpoints) {
        this.checkpoints = checkpoints;
    }

    public SessionInfo(String id, Timestamp started, Timestamp finished, long duration, ExecutionStatus executionStatus, String chainId, String chainName, String domain, String engineAddress, String loggingLevel, String snapshotName, String correlationId, SessionInfo parentSession, List<Checkpoint> checkpoints) {
        this.id = id;
        this.started = started;
        this.finished = finished;
        this.duration = duration;
        this.executionStatus = executionStatus;
        this.chainId = chainId;
        this.chainName = chainName;
        this.domain = domain;
        this.engineAddress = engineAddress;
        this.loggingLevel = loggingLevel;
        this.snapshotName = snapshotName;
        this.correlationId = correlationId;
        this.parentSession = parentSession;
        this.checkpoints = checkpoints;
    }

    public SessionInfo() {
    }
}

