/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import io.grpc.Status;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor;
import java.util.Collection;
import java.util.function.UnaryOperator;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.MetricTagsHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
public class GrpcElementDependencyBinder
extends ElementProcessingAction {
    private final MetricsStore metricsStore;
    private final MetricTagsHelper metricTagsHelper;

    @Autowired
    public GrpcElementDependencyBinder(MetricsStore metricsStore, MetricTagsHelper metricTagsHelper) {
        this.metricsStore = metricsStore;
        this.metricTagsHelper = metricTagsHelper;
    }

    @Override
    public boolean applicableTo(ElementProperties properties) {
        String elementType = properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString(elementType);
        String protocol = properties.getProperties().get("integrationOperationProtocolType");
        return ChainElementType.SERVICE_CALL.equals((Object)chainElementType) && "grpc".equals(protocol);
    }

    @Override
    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        if (this.metricsStore.isMetricsEnabled()) {
            Collection<Tag> tags = this.metricTagsHelper.buildMetricTagsLegacy(deploymentInfo, properties, deploymentInfo.getChainName());
            UnaryOperator counterCustomizer = counter -> counter.tags(tags);
            UnaryOperator timerCustomizer = timer -> timer.tags(tags);
            MetricCollectingClientInterceptor metricInterceptor = new MetricCollectingClientInterceptor(this.metricsStore.getMeterRegistry(), counterCustomizer, timerCustomizer, new Status.Code[]{Status.Code.OK});
            String elementId = properties.getElementId();
            context.getRegistry().bind(elementId, (Object)metricInterceptor);
        }
    }
}

