/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism.deserializers;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.qubership.integration.platform.engine.opensearch.ism.model.time.TimeValue;

public class TimeValueDeserializer
extends JsonDeserializer<TimeValue> {
    public TimeValue deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        TreeNode node = jsonParser.readValueAsTree();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            return TimeValue.parseTimeValue((String)textNode.textValue(), (String)jsonParser.getCurrentName());
        }
        String message = String.format("Wrong %s field type", jsonParser.getCurrentName());
        throw InvalidFormatException.from((JsonParser)jsonParser, (String)message, (Object)node.asToken().asString(), TimeValue.class);
    }
}

