/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.repository;

import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface SessionInfoRepository
extends JpaRepository<SessionInfo, String> {
    public List<SessionInfo> findAllByChainIdAndExecutionStatus(String var1, ExecutionStatus var2);

    @Modifying
    @Query(nativeQuery=true, value="WITH RECURSIVE to_root_node (id, original_session_id) AS (         SELECT s1.id, s1.original_session_id         FROM engine.sessions_info s1         WHERE s1.id = :sessionId         UNION ALL         SELECT s2.id, s2.original_session_id         FROM engine.sessions_info s2                  JOIN to_root_node rn ON rn.original_session_id = s2.id )DELETE FROM engine.sessions_info WHERE id = (SELECT id FROM to_root_node WHERE original_session_id IS NULL LIMIT 1);")
    public void deleteAllRelatedSessionsAndCheckpoints(String var1);

    @Query(nativeQuery=true, value="with recursive session_info as (\n    select s1.*\n        from engine.sessions_info s1\n        where s1.id = :sessionId\n    union all\n    select s2.*\n        from engine.sessions_info s2\n        join session_info si on s2.id = si.original_session_id\n)\nselect * from session_info i\n    where i.id != :sessionId and i.original_session_id is null\n    limit 1;\n")
    public Optional<SessionInfo> findOriginalSessionInfo(String var1);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM engine.sessions_info s1 WHERE s1.started < now() - ( :olderThan )\\:\\:interval AND s1.original_session_id IS NULL")
    public void deleteOldRecordsByInterval(String var1);
}

