/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class CustomErrorController
extends AbstractErrorController {
    @Autowired
    public CustomErrorController(ErrorAttributes errorAttributes, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
    }

    @RequestMapping
    public ResponseEntity<?> error(HttpServletRequest request) {
        if (this.isChainRequest(request)) {
            ErrorCodeException status = this.getChainErrorStatus(request);
            return new ResponseEntity((Object)status.buildResponseObject(), (HttpStatusCode)HttpStatus.valueOf((int)status.getErrorCode().getHttpErrorCode()));
        }
        return this.getBasicErrorResponse(request);
    }

    private ResponseEntity<Map<String, Object>> getBasicErrorResponse(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity((HttpStatusCode)status);
        }
        Map body = this.getErrorAttributes(request, ErrorAttributeOptions.defaults());
        return new ResponseEntity((Object)body, (HttpStatusCode)status);
    }

    private ErrorCodeException getChainErrorStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        return switch (statusCode) {
            case 405 -> new ErrorCodeException(ErrorCode.METHOD_NOT_ALLOWED, new String[]{request.getMethod()});
            case 404 -> new ErrorCodeException(ErrorCode.CHAIN_ENDPOINT_NOT_FOUND, new String[0]);
            default -> new ErrorCodeException(ErrorCode.UNEXPECTED_BUSINESS_ERROR, new String[0]);
        };
    }

    private boolean isChainRequest(HttpServletRequest request) {
        String requestUri = (String)request.getAttribute("jakarta.servlet.error.request_uri");
        return !StringUtils.isBlank((CharSequence)requestUri) && requestUri.startsWith("/routes");
    }
}

