/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.Message;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;
import org.qubership.integration.platform.engine.util.ExchangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ChainsAggregationStrategy
implements AggregationStrategy {
    private static final Logger log = LoggerFactory.getLogger(ChainsAggregationStrategy.class);
    private static final String SPLIT_MAIN_BRANCH_TYPE = "main";
    private static final String CAMEL_HTTP_RESPONSE_CODE_VALUE = "200";
    private final ObjectMapper objectMapper;

    @Autowired
    public ChainsAggregationStrategy(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        if (oldExchange == null) {
            if (this.hadException(newExchange)) {
                return null;
            }
            this.processHeaders(newExchange, (Exchange)null, inputExchange);
            this.processProperties(newExchange, (Exchange)null, inputExchange);
            return this.aggregate(oldExchange, newExchange);
        }
        if (this.hadException(newExchange)) {
            return oldExchange;
        }
        this.processHeaders(oldExchange, newExchange, inputExchange);
        this.processProperties(oldExchange, newExchange, inputExchange);
        return this.aggregate(oldExchange, newExchange);
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            ObjectNode newBodyWrapped = this.objectMapper.createObjectNode();
            this.processPayload(newExchange, newExchange, newBodyWrapped);
            return newExchange;
        }
        try {
            ObjectNode oldBody = (ObjectNode)this.objectMapper.readTree((String)oldExchange.getMessage().getBody(String.class));
            this.processPayload(oldExchange, newExchange, oldBody);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
        }
        this.clearBranchName(oldExchange);
        return oldExchange;
    }

    private void processHeaders(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        Map headers = inputExchange.getMessage().getHeaders();
        this.processHeaders(oldExchange, headers, inputExchange);
        this.processHeaders(newExchange, headers, inputExchange);
        Message message = oldExchange.getMessage();
        message.setHeaders(headers);
    }

    private void processHeaders(Exchange exchange, Map<String, Object> headers, Exchange inputExchange) {
        if (exchange != null) {
            if (!this.exchangeHeaderProcessed(inputExchange)) {
                ArrayList keysToRemove = new ArrayList();
                Map inputHeaders = inputExchange.getMessage().getHeaders();
                inputHeaders.forEach((key, value) -> {
                    if (exchange.getMessage().getHeaders().containsKey(key)) {
                        headers.put((String)key, value);
                    } else {
                        keysToRemove.add(key);
                    }
                });
                keysToRemove.forEach(inputHeaders::remove);
            }
            inputExchange.setProperty("internalProperty_splitExchangeHeaderProcessed", (Object)true);
            if (this.isHeadersPropagationEnabled(exchange) || this.isMainBranch(exchange)) {
                String branchName = this.getBranchName(exchange);
                exchange.getMessage().getHeaders().forEach((key, value) -> {
                    if (!CamelConstants.isInternalHeader(key)) {
                        if (!this.exchangeHeaderProcessed(exchange) && !this.isMainBranch(exchange)) {
                            key = String.format("%s.%s", branchName, key);
                        }
                        headers.put((String)key, value);
                    }
                });
                exchange.setProperty("internalProperty_splitExchangeHeaderProcessed", (Object)true);
            }
        }
    }

    private void processProperties(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        Map properties = inputExchange.getProperties();
        this.processProperties(oldExchange, properties, inputExchange);
        String branchName = (String)oldExchange.getProperty("internalProperty_splitId");
        Boolean headerProcessed = this.exchangeHeaderProcessed(oldExchange);
        Boolean headerPropagationEnabled = this.isMainBranch(oldExchange) || this.isHeadersPropagationEnabled(oldExchange);
        Boolean propertiesPropagationEnabled = this.isMainBranch(oldExchange) || this.isPropertiesPropagationEnabled(oldExchange);
        oldExchange.removeProperties(".*");
        oldExchange.setProperty("internalProperty_exchangePropertiesProcessed", (Object)true);
        oldExchange.setProperty("internalProperty_splitExchangeHeaderProcessed", (Object)headerProcessed);
        oldExchange.setProperty("internalProperty_splitId", (Object)branchName);
        oldExchange.setProperty("internalProperty_propagateHeaders", (Object)headerPropagationEnabled);
        oldExchange.setProperty("internalProperty_propagateProperties", (Object)propertiesPropagationEnabled);
        this.processProperties(newExchange, properties, inputExchange);
        properties.forEach((arg_0, arg_1) -> ((Exchange)oldExchange).setProperty(arg_0, arg_1));
    }

    private void processProperties(Exchange exchange, Map<String, Object> properties, Exchange inputExchange) {
        if (exchange != null) {
            if (!this.exchangePropertiesProcessed(inputExchange)) {
                ArrayList propertiesToRemove = new ArrayList();
                Map inputProperties = inputExchange.getProperties();
                inputProperties.forEach((key, value) -> {
                    if (exchange.getProperties().containsKey(key)) {
                        properties.put((String)key, value);
                    } else {
                        propertiesToRemove.add(key);
                    }
                });
                propertiesToRemove.forEach(inputProperties::remove);
            }
            inputExchange.setProperty("internalProperty_exchangePropertiesProcessed", (Object)true);
            if (this.isPropertiesPropagationEnabled(exchange) || this.isMainBranch(exchange)) {
                String branchName = this.getBranchName(exchange);
                exchange.getProperties().forEach((key, value) -> {
                    if (!ExchangeUtils.isCommonOrSystemVariableMap(key) && !CamelConstants.isInternalProperty(key)) {
                        if (!this.exchangePropertiesProcessed(exchange) && !this.isMainBranch(exchange)) {
                            key = String.format("%s.%s", branchName, key);
                        }
                        properties.put((String)key, value);
                    }
                });
            }
        }
    }

    private String getBranchName(Exchange exchange) {
        return (String)exchange.getProperty("internalProperty_splitId", String.class);
    }

    private void clearBranchName(Exchange exchange) {
        exchange.removeProperty("internalProperty_splitId");
        exchange.removeProperty("internalProperty_splitIdChain");
    }

    private void processPayload(Exchange oldExchange, Exchange newExchange, ObjectNode oldBody) {
        String rawExchange = (String)newExchange.getMessage().getBody(String.class);
        try {
            JsonNode newBody = this.objectMapper.readTree(rawExchange);
            oldBody.replace(this.getBranchName(newExchange), this.objectMapper.readTree(this.objectMapper.writeValueAsString((Object)newBody)));
        }
        catch (JsonProcessingException | ClassCastException | IllegalArgumentException e) {
            oldBody.replace(this.getBranchName(newExchange), (JsonNode)new TextNode(rawExchange));
        }
        oldExchange.getIn().setBody((Object)oldBody);
        oldExchange.getIn().setHeader("CamelHttpResponseCode", (Object)CAMEL_HTTP_RESPONSE_CODE_VALUE);
        oldExchange.setProperty("internalProperty_splitProcessed", (Object)true);
    }

    private boolean isHeadersPropagationEnabled(Exchange exchange) {
        return (Boolean)exchange.getProperty("internalProperty_propagateHeaders", (Object)Boolean.FALSE, Boolean.class);
    }

    private boolean isPropertiesPropagationEnabled(Exchange exchange) {
        return (Boolean)exchange.getProperty("internalProperty_propagateProperties", (Object)Boolean.FALSE, Boolean.class);
    }

    private boolean exchangeHeaderProcessed(Exchange exchange) {
        return (Boolean)exchange.getProperty("internalProperty_splitExchangeHeaderProcessed", (Object)Boolean.FALSE, Boolean.class);
    }

    private boolean exchangeProcessed(Exchange exchange) {
        return (Boolean)exchange.getProperty("internalProperty_splitProcessed", (Object)Boolean.FALSE, Boolean.class);
    }

    private boolean exchangePropertiesProcessed(Exchange exchange) {
        return (Boolean)exchange.getProperty("internalProperty_exchangePropertiesProcessed", (Object)Boolean.FALSE, Boolean.class);
    }

    private boolean isMainBranch(Exchange exchange) {
        return ((String)exchange.getProperty("internalProperty_splitBranchType", (Object)"", String.class)).equals(SPLIT_MAIN_BRANCH_TYPE);
    }

    private boolean hadException(Exchange exchange) {
        if (exchange.isFailed()) {
            return true;
        }
        if (exchange.isRollbackOnly()) {
            return true;
        }
        if (exchange.isRollbackOnlyLast()) {
            return true;
        }
        ExchangeExtension exchangeExtension = exchange.getExchangeExtension();
        return exchangeExtension.isErrorHandlerHandledSet() && exchangeExtension.isErrorHandlerHandled();
    }
}

