/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.qubership.integration.platform.engine.camel.components.servlet.CustomHttpRestServletResolveConsumerStrategy;

public class CustomCamelHttpTransportServlet
extends CamelHttpTransportServlet {
    private final ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap();

    public void init(ServletConfig config) throws ServletException {
        this.log.debug("CustomCamelHttpTransportServlet init");
        super.init(config);
        this.setServletResolveConsumerStrategy((ServletResolveConsumerStrategy)new CustomHttpRestServletResolveConsumerStrategy());
    }

    public void connect(HttpConsumer consumer) {
        ServletEndpoint endpoint = this.getServletEndpoint(consumer);
        if (endpoint.getServletName() != null && endpoint.getServletName().equals(this.getServletName())) {
            this.log.debug("Connecting consumer: {}", (Object)consumer);
            this.consumers.put(consumer.getEndpoint().getEndpointUri(), consumer);
        }
    }

    public void disconnect(HttpConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getEndpoint().getEndpointUri());
    }

    public Map<String, HttpConsumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }

    private ServletEndpoint getServletEndpoint(HttpConsumer consumer) {
        if (!(consumer.getEndpoint() instanceof ServletEndpoint)) {
            throw new RuntimeException("Invalid consumer type. Must be ServletEndpoint but is " + consumer.getClass().getName());
        }
        return (ServletEndpoint)consumer.getEndpoint();
    }
}

