/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.OpenSearchGenericClient;
import org.opensearch.client.opensearch.generic.Response;
import org.opensearch.client.transport.httpclient5.ResponseException;
import org.qubership.integration.platform.engine.opensearch.ism.model.Policy;
import org.qubership.integration.platform.engine.opensearch.ism.rest.ISMStatusResponse;
import org.qubership.integration.platform.engine.opensearch.ism.rest.PolicyResponse;
import org.qubership.integration.platform.engine.opensearch.ism.rest.RequestHelper;

public class IndexStateManagementClient {
    private final OpenSearchGenericClient client;
    private final ObjectMapper jsonMapper;

    public IndexStateManagementClient(OpenSearchClient client, ObjectMapper jsonMapper) {
        this.client = client.generic();
        this.jsonMapper = jsonMapper;
    }

    public PolicyResponse getPolicy(String policyId, boolean optional) throws IOException {
        Response response = this.getRestClient().execute(RequestHelper.buildGetPolicyRequest((String)policyId));
        if (optional && response.getStatus() == 404) {
            return null;
        }
        return (PolicyResponse)this.deserializeResponseData(response, PolicyResponse.class);
    }

    public Optional<PolicyResponse> tryGetPolicy(String policyId) throws IOException {
        try {
            return Optional.ofNullable(this.getPolicy(policyId, true));
        }
        catch (ResponseException exception) {
            if (exception.status() == 404) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PolicyResponse createPolicy(Policy policy) throws IOException {
        Response response = this.getRestClient().execute(RequestHelper.buildCreatePolicyRequest((ObjectMapper)this.jsonMapper, (Policy)policy));
        return (PolicyResponse)this.deserializeResponseData(response, PolicyResponse.class);
    }

    public PolicyResponse updatePolicy(Policy policy, long seqNo, long primaryTerm) throws IOException {
        Response response = this.getRestClient().execute(RequestHelper.buildUpdatePolicyRequest((ObjectMapper)this.jsonMapper, (Policy)policy, (long)seqNo, (long)primaryTerm));
        return (PolicyResponse)this.deserializeResponseData(response, PolicyResponse.class);
    }

    public ISMStatusResponse addPolicy(String indexName, String policyId) throws IOException {
        Response response = this.getRestClient().execute(RequestHelper.buildAddPolicyRequest((ObjectMapper)this.jsonMapper, (String)indexName, (String)policyId));
        return (ISMStatusResponse)this.deserializeResponseData(response, ISMStatusResponse.class);
    }

    public ISMStatusResponse removePolicy(String indexName) throws IOException {
        Response response = this.getRestClient().execute(RequestHelper.buildRemovePolicyFromIndexRequest((String)indexName));
        return (ISMStatusResponse)this.deserializeResponseData(response, ISMStatusResponse.class);
    }

    private OpenSearchGenericClient getRestClient() {
        return this.client;
    }

    private <T> T deserializeResponseData(Response response, Class<T> cls) throws IOException {
        RequestHelper.processHttpResponse((Response)response);
        return (T)(response.getBody().isPresent() ? this.jsonMapper.readValue(((Body)response.getBody().get()).bodyAsString(), cls) : null);
    }
}

